package com.blt.other.module.entrepot.service.impl;

import com.blt.other.module.database.mapper.StatusMapper;
import com.blt.other.module.database.model.BuyDomain;
import com.blt.other.module.database.model.StorageDomain;
import com.blt.other.module.entrepot.dao.StorageDao;
import com.blt.other.module.entrepot.dto.StorageDto;
import com.blt.other.module.entrepot.service.StorageService;
import com.blt.other.module.purchasing.dao.BuyDao;
import com.blt.other.module.purchasing.vo.CashierCallbackUrlVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

@Service
public class StorageServiceImpl implements StorageService {

    private static final Logger logger = LoggerFactory.getLogger(StorageServiceImpl.class);

    @Autowired
    private StorageDao storageDao;

    @Autowired
    private BuyDao buyDao;

    @Autowired
    private StatusMapper statusMapper;
    @Override
    public Integer saveStorage(String buyno,String responseMsg) {
        //  从反馈的出纳信息中获取实际付款金额
        ObjectMapper mapper = new ObjectMapper();
        CashierCallbackUrlVo cashierCallbackUrlVo = null;
        try {
            cashierCallbackUrlVo = mapper.readValue(responseMsg,CashierCallbackUrlVo.class);

        } catch (IOException e) {
        }

        Random random = new Random();
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain = buyDao.selectBuy(buyDomain);
        System.out.println(buyDomain);
        StorageDomain storageDomain = new StorageDomain();
        BeanUtils.copyProperties(buyDomain,storageDomain);
        System.out.println(storageDomain);
        storageDomain.setStorageno("SG"+System.currentTimeMillis()+random.nextInt(99));
        storageDomain.setPayamount(cashierCallbackUrlVo.getData().getData().getPayamount());

        Integer insert = null;
        insert = storageDao.insert(storageDomain);
        if (null == insert && insert < 1){
            logger.warn("入库单保存失败"+storageDomain);
        }else {
            logger.warn("入库单保存"+storageDomain);
        }

        return insert;
    }

    @Override
    public Integer saveStorageByBuy(String buyno) {
        Random random = new Random();
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain = buyDao.selectBuy(buyDomain);
        System.out.println(buyDomain);
        StorageDomain storageDomain = new StorageDomain();
        BeanUtils.copyProperties(buyDomain,storageDomain);
        System.out.println(storageDomain);
        storageDomain.setStorageno("SG"+System.currentTimeMillis()+random.nextInt(99));
        storageDomain.setPayamount(buyDomain.getAmount());
        Integer insert = null;
        insert = storageDao.insert(storageDomain);
        if (null == insert && insert < 1){
            logger.warn("入库单保存失败"+storageDomain);
        }else {
            logger.warn("入库单保存"+storageDomain);
        }
        return insert;
    }

    @Override
    public Map<String,Object> getAllStorage(Integer pagesize, Integer page) {
        Map<String,Object> resultMap = new HashMap<>();
        Map<String, Object> storageDtos = getStorageDtos(pagesize, page);
        resultMap.put("storages", storageDtos.get("storageDtos"));
        resultMap.put("pageInfo", storageDtos.get("pageInfo"));
        return resultMap;
    }

    /**
     * 通过 storageno 获取 StorageDto
     * @param storageno
     * @return
     */
    @Override
    public StorageDto getStorageByStorageno(String storageno) {
        StorageDomain select = storageDao.select(storageno);
        StorageDto storageDto = storageDomainToDto(select);
        return storageDto;
    }

    @Override
    public Integer update(StorageDomain storageDomain) {
        Integer update = storageDao.update(storageDomain);
        return update;
    }

    /**
     * 根据 buyno 获取入库表
     * @param buyNo
     * @return
     */
    @Override
    public StorageDto getStorageByBuyNo(String buyNo) {
        StorageDomain storageDomain = storageDao.selectByBuyNo(buyNo);
        StorageDto storageDto = storageDomainToDto(storageDomain);
        return storageDto;
    }

    /**
     * 获取用于 view 层展示的入库单列表
     * @return
     */
    private  Map<String,Object> getStorageDtos(Integer pagesize,Integer page){
        Map<String,Object> map = new HashMap<>();
        logger.warn("分页查询入库单列表：pagesize "+pagesize+" ，page "+page);
        PageHelper.startPage(page,pagesize);
        List<StorageDomain> storageDomains = storageDao.selectAll();
        PageInfo<StorageDomain> pageInfo = new PageInfo<>(storageDomains);
        map.put("pageInfo",pageInfo);
        List<StorageDto> storageDtos = new ArrayList<>();
        if (null != storageDomains && storageDomains.size() >=1){
            StorageDto storageDto = null;
            for (StorageDomain storageDomain : storageDomains){
                storageDto = storageDomainToDto(storageDomain);
                storageDtos.add(storageDto);

            }

        }
        map.put("storageDtos",storageDtos);
        return map;
    }

    /**
     * 将从数据库获取的 StorageDomain 转为 view 层的 storageDto
     * @param storageDomain
     * @return
     */
    @Override
    public StorageDto storageDomainToDto(StorageDomain storageDomain){
        if (null == storageDomain){
            return null;
        }
        StorageDto storageDto = new StorageDto();
        BeanUtils.copyProperties(storageDomain,storageDto);
        // 获取状态
        storageDto.setBuystatusDto(statusMapper.getStatusValue("buystatus", storageDomain.getBuystatus()));
        storageDto.setPaytypeDto(statusMapper.getStatusValue("paytype",storageDomain.getPaytype()));
        storageDto.setSendstatusDto(statusMapper.getStatusValue("sendstatus",storageDomain.getSendstatus()));
        return storageDto;
    }
}
