package com.blt.other.module.auth.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.module.auth.model.OaCompany;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface OaCompanyMapper extends BaseMapper<OaCompany> {

    /**
     * <p>
     * 获取财务审核人配置列表
     * </p>
     *
     * @param page page
     * @param req  req
     * @return 财务审核人配置列表
     */
    IPage<OaCompany> reviewerList(@Param("page") IPage<OaCompany> page, @Param("req") CompanyReviewerListReq req);

    /**
     * <p>
     * 根据oa公司id
     * </p>
     *
     * @param oaCompanyId oa公司id
     * @return res
     */
    OaCompany selectByCompanyId(Integer oaCompanyId);
}
