package com.blt.other.other_sku.service.impl;

import com.blt.other.other_database.model.SkuTypeDomain;
import com.blt.other.other_sku.dao.SkuTypeDao;
import com.blt.other.other_sku.service.SkuTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class SkuTypeServiceImpl implements SkuTypeService {

    @Autowired
    private SkuTypeDao skuTypeDao;

    /**
     * 保存大类
     * @param skuTypeDomain
     * @return
     */
    @Override
    public Integer saveSkuType(SkuTypeDomain skuTypeDomain) {
        String skuTypeNo = createSkuTypeNo();
        skuTypeDomain.setSkuTypeNo(skuTypeNo);
        Integer insert = skuTypeDao.insert(skuTypeDomain);
        return insert;
    }

    @Override
    public SkuTypeDomain getBySkuTypeNo(String skuTypeNo) {
        return skuTypeDao.selectBySkuTypeNo(skuTypeNo);
    }

    @Override
    public List<SkuTypeDomain> getListBySkuTypeName(String skuTypeName) {
        return skuTypeDao.selectBySkuTypeName(skuTypeName);
    }

    @Override
    public List<SkuTypeDomain> getAllTypes() {
        return skuTypeDao.selectAll();
    }

    /**
     * 生成唯一编号
     * @return
     */
    private String createSkuTypeNo(){
        String skuTypeNo = null;
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        skuTypeNo = "STN"+sdf.format(new Date())+random.nextInt(9);
        SkuTypeDomain skuTypeDomain = skuTypeDao.selectBySkuTypeNo(skuTypeNo);
        while (null != skuTypeDomain && null != skuTypeDomain.getSkuTypeNo()){
            skuTypeNo = "STN"+sdf.format(new Date())+random.nextInt(9);
            skuTypeDomain = skuTypeDao.selectBySkuTypeNo(skuTypeNo);
        }
        return skuTypeNo;
    }
}
