package com.blt.other.other_cost.utils;

import com.blt.other.other_commons.utils.PathUtil;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * 费用模块文件上传、下载工具类
 */
public class CostFileUtil {

    public static String upload(MultipartFile file,String filePath){

        // 获取文件名
        String fileName = file.getOriginalFilename();
        // 获取后缀
        String suffixName = fileName.substring(fileName.lastIndexOf("."));

        // fileName处理
        fileName = filePath+ UUID.randomUUID()+"&"+fileName;
        // 文件对象
        File dest = new File(fileName);
        // 创建路径
        if(!dest.getParentFile().exists()){
            dest.getParentFile().mkdirs();
        }
        try {
            file.transferTo(dest);
        } catch (IOException e) {
//            logger.error("affirmFile 发生错误",e);
        }
        return fileName;
    }
}
