package com.blt.other.other_entrepot.service.impl;

import com.blt.other.other_database.model.WarehouseDomain;
import com.blt.other.other_entrepot.dao.WarehouseDao;
import com.blt.other.other_entrepot.service.WarehouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class WarehouseServiceImple implements WarehouseService {
    @Autowired
    private WarehouseDao warehouseDao;

    @Override
    public String createWarehouseid() {
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String warehouseid = "WH"+sdf.format(new Date())+random.nextInt(9);
        WarehouseDomain domain = warehouseDao.select(warehouseid);
        if (null != domain && !domain.getWarehousename().isEmpty()){
            warehouseid = "WH"+sdf.format(new Date())+random.nextInt(9);
            domain = warehouseDao.select(warehouseid);
        }
        return warehouseid;
    }

    @Override
    public WarehouseDomain getByWarehosueid(String warehouseid) {
        return warehouseDao.select(warehouseid);
    }

    @Override
    public Integer insert(WarehouseDomain warehouse) {
        return warehouseDao.insert(warehouse);
    }

    @Override
    public WarehouseDomain getByWarehousename(String warehousename) {
        return warehouseDao.selectByWarehousename(warehousename);
    }

    @Override
    public List<WarehouseDomain> getWarehouseList() {
        return warehouseDao.selectList();
    }

    @Override
    public Integer update(WarehouseDomain warehouse) {
        return warehouseDao.update(warehouse);
    }
}
