package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.request.ApplyMoneyDetail;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.CashierCallbackUrlDataDataVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlDataVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlVo;
import com.blt.other.module.cost.vo.Paydetail;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/9 11:19 上午
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("test")
class AbstractCostServiceTest {
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    CostUrlProperties costUrlProperties;
    @Resource
    CostDao costDao;


    PostApplyReq buildPostApplyReq(CostDomain cost) {
        CostCompanyDomain companyByCompanyNo = costCompanyDao.selectByNo(cost.getCompanyNo());


        PostApplyReq req = new PostApplyReq();
        // 公司主体(CompanyMainName)不可为空；
        req.setCompanyMainName(cost.getCompanyName());
        req.setTitle(cost.getCostNo());

        // 币种编号(UnitCode)不可为空；
        req.setUnitCode(cost.getDic());
        // 币种名称(UnitName)不可为空；
        req.setUnitName(cost.getDic());

        // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        req.setTradeObjectID(companyByCompanyNo.getValue() + "");
        req.setTradeObjectName(cost.getBankCompany() + "");

        // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        req.setBankCardto(cost.getBankCard());
        req.setBankCardUserto(cost.getBankCardUser());
        req.setBankNameto(cost.getBankName());

        // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        req.setSourceCode("newCost");
        req.setSourceTypeCode("newCostType");
        // 账期 0 PayDay
        req.setPayDay(0);
        // 预计付款时间 ExpectPayTime
        req.setExpectPayTime(new Date());

        // 申请人(UserAcctID/UserAcctName)不存在；
        req.setUserAcctID("" + cost.getCreateUserid());
        req.setUserAcctName("" + cost.getCreateUsername());


        // 设置 detailKey
        String detailKey = cost.getDetailKey();
        if (null == detailKey || !detailKey.contains("F")) {
            detailKey = cost.getCostNo();
        }
        // 回调必要的key参数（DetailKey）不能为空；
        req.setDetailKey(detailKey);
        req.setTypeName(cost.getTypeName());
        return req;
    }


    @Test
    void toFinancial() {
        CostDomain costDomain = costDao.selectByCostNo("F030246");

        PostApplyReq req = this.buildPostApplyReq(costDomain);
        // 审核回调地址(ApplyCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costUrlProperties.costApplyCallbackUrlPost);
        // 出纳回调地址(CashierCallbackUrl)不可为空；
        req.setCashierCallbackUrl(costUrlProperties.costCashierCallbackUrlPost);
        req.setApplyType("" + 1);

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        applyMoneyDetail.setName("借支单付款");
        applyMoneyDetail.setMoney(costDomain.getAmount());

        //todo
        applyMoneyDetail.setMoneyRmb(costDomain.getAmount());
        applyMoneyDetail.setRemark("");

        applyMoneyDetailList.add(applyMoneyDetail);
        // 出纳申请金额明细(MoneyDetail)不可为空；
        req.setMoneyDetail(applyMoneyDetailList);


        log.info(JsonUtilByFsJson.beanToJson(req));

    }

    @Test
    void applyCallback() {
    }

    @Test
    void cashierCallback() {
        Paydetail paydetail = new Paydetail();

        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = new CashierCallbackUrlDataDataVo();
        cashierCallbackUrlDataDataVo.setPaydetail(paydetail);


        CashierCallbackUrlDataVo cashierCallbackUrlDataVo = new CashierCallbackUrlDataVo();
        cashierCallbackUrlDataVo.setSuccess(true);
        cashierCallbackUrlDataVo.setMessage("");
        cashierCallbackUrlDataVo.setData("\"" + JsonUtilByFsJson.beanToJson(cashierCallbackUrlDataDataVo) + "\"");


        CashierCallbackUrlVo cashierCallbackUrlVo = new CashierCallbackUrlVo();
        cashierCallbackUrlVo.setId("1325636721139646466");
        cashierCallbackUrlVo.setData(cashierCallbackUrlDataVo);


    }

    @Test
    void cashierCallbackReject() {
    }

    @Test
    void cashierCallbackPass() {
    }


}
