package com.blt.other;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.bailuntec.common.SpringContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.database.model.CostCompanyDomain;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/12 2:27 下午
 */
public class CostCompanyDomainListener extends AnalysisEventListener<CostCompanyExcel> {


    private static final Logger LOGGER = LoggerFactory.getLogger(CostCompanyDomain.class);
    /**
     * 每隔5条存储数据库，实际使用中可以3000条，然后清理list ，方便内存回收
     */
    private static final int BATCH_COUNT = 5;

    List<CostCompanyExcel> list = new ArrayList<>();


    @Override
    public void invoke(CostCompanyExcel data, AnalysisContext context) {
        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        LOGGER.info("所有数据解析完成！");
    }

    /**
     * 加上存储数据库
     */
    private void syncData() {
        LOGGER.info("{}条数据，开始存储数据库！", list.size());
        list.forEach(costCompanyExcel -> {

            CostCompanyDao costCompanyDao = SpringContextUtil.getBean(CostCompanyDao.class);
            CostReviewerMapper costReviewerMapper = SpringContextUtil.getBean(CostReviewerMapper.class);
            OaUserMapper oaUserMapper = SpringContextUtil.getBean(OaUserMapper.class);


            CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costCompanyExcel.getCompanyNo());

            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            Lists.newArrayList(costCompanyExcel.getFinancialCheckUserName().split("、")).forEach(
                    name -> {
                        OaUser oaUser = oaUserMapper.selectByUserName(name);
                        CostReviewer costReviewer = CostReviewer.builder()
                                .reviewerUserId(oaUser.getOaUserId())
                                .reviewerUserName(oaUser.getUserName())
                                .referId(costCompanyDomain.getId())
                                .type(CostReviewer.financialReviewer)
                                .build();

                        costReviewerMapper.insert(costReviewer);
                    }
            );

            OaUser oaUser = oaUserMapper.selectByUserName(costCompanyExcel.getFinalCheckUserName());
            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(oaUser.getOaUserId())
                    .reviewerUserName(oaUser.getUserName())
                    .referId(costCompanyDomain.getId())
                    .type(CostReviewer.finalReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);


        });
        LOGGER.info("存储数据库成功！");
    }
}
