package com.blt.other.module.sys.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="SpecDepartmentCheckConfig对象", description="")
public class SpecDepartmentCheckConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "付款财务主体id")
    private Integer costCompanyId;

    @ApiModelProperty(value = "付款财务主体")
    private String costCompanyName;

    @ApiModelProperty(value = "申请人oa公司id")
    private Integer oaCompanyId;

    @ApiModelProperty(value = "申请人oa公司")
    private String oaCompany;

    @ApiModelProperty(value = "特殊审核人oa用户id")
    private Integer reviewerUserId;

    @ApiModelProperty(value = "特殊审核人")
    private String reviewerUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty(value = "修改人id")
    private Integer updateUserId;

    @ApiModelProperty(value = "修改人")
    private String updateUserName;


}
