package com.blt.other.module.purchasing.controller;

import com.alibaba.fastjson.JSON;
import com.bailuntec.cost.api.domain.BuyDomain;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.IpUtil;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.utils.CostFileUtil;
import com.blt.other.database.model.*;
import com.blt.other.module.entrepot.dto.InventoryLogDto;
import com.blt.other.module.entrepot.dto.StorageDto;
import com.blt.other.module.entrepot.service.InventoryLogService;
import com.blt.other.module.entrepot.service.InventoryService;
import com.blt.other.module.entrepot.service.StorageService;
import com.blt.other.module.purchasing.dto.BuyListDto;
import com.blt.other.module.purchasing.service.*;
import com.blt.other.module.purchasing.vo.ApplyCallbackUrlVo;
import com.blt.other.module.purchasing.vo.ApplyCallbackVo;
import com.blt.other.module.purchasing.vo.ApplyMoneyDetail;
import com.blt.other.module.purchasing.vo.CashierCallbackUrlVo;
import com.blt.other.module.sku.service.SysProductService;
import com.blt.other.module.supplier.service.SupplierService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("purchasing/list/detail")
public class PurchasingListDetailController {
    private static Logger logger = LoggerFactory.getLogger(PurchasingListDetailController.class);

    @Autowired
    private BuyService buyService;
    @Autowired
    private SysProductService sysProductService;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TofinanceService tofinanceService;
    @Autowired
    private ApplycallbackService applycallbackService;
    @Autowired
    private CashiercallbackService cashiercallbackService;
    @Autowired
    private StorageService storageService;
    @Autowired
    private InventoryService inventoryService;
    @Autowired
    private InventoryLogService inventoryLogService;
    @Autowired
    private BuyDetailService buyDetailService;
    @Autowired
    private BuyLogService buyLogService;
    @Autowired
    private CostService costService;
    @Autowired
    CostDao costDao;


    /**
     * 通过采购单号获取采购单详情
     *
     * @param response
     * @param request
     * @return
     */
    @GetMapping("getBuyDetail")
    public Map<String, Object> getBuyDetail(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String buyno = request.getParameter("buyno");
        BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);
        result.put("buy", buyByBuyno);

        StorageDto storageByBuyNo = storageService.getStorageByBuyNo(buyno);
        result.put("storage", storageByBuyNo);

        return result;

    }

    @GetMapping("/download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String buyno = request.getParameter("buyno");
        BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);
        String filePath = null;
        String fileName = null;
        if (null != buyByBuyno) {
            filePath = buyByBuyno.getFilepath();
            if (null != filePath) {
                String[] split = filePath.split("&");
                if (null != split && split.length >= 1) {
                    fileName = split[split.length - 1];
                }
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    /**
     * 通过采购单号获取采购单子项目列表
     *
     * @param response
     * @param request
     * @return
     */
    @GetMapping("getBuyDetailList")
    public Map<String, Object> getBuyDetailList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String buyno = request.getParameter("buyno");
        List<BuyDetailDomain> detailListByBuyno = buyDetailService.getDetailListByBuyno(buyno);
        BigDecimal amount = new BigDecimal(0);
        if (null != detailListByBuyno && detailListByBuyno.size() >= 1) {
            for (BuyDetailDomain detail : detailListByBuyno) {
                amount = amount.add(detail.getAmount());
            }
        }
        result.put("amount", amount);
        result.put("success", true);
        result.put("details", detailListByBuyno);

        return result;
    }

    /**
     * 确认采购单
     *
     * @param request
     * @return
     */
    @PostMapping("afirm")
    public Map<String, Object> afirm(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String buyno = request.getParameter("buyno");
        String buystatus = request.getParameter("buystatus");
        String note = request.getParameter("note");
        Map<String, Object> result = new HashMap<>();

        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setBuystatus(Integer.parseInt(buystatus));
        buyDomain.setNote(note);
        // 获取采购单信息，判断是否符合改变条件
        BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);
        if (buyByBuyno.getBuystatus() >= Integer.parseInt(buystatus)) {
            result.put("success", "warn");
            result.put("msg", buyByBuyno.getBuystatusDto());
            result.put("buy", buyByBuyno);
            return result;
        }
        Integer update = buyService.getUpdate(buyDomain);
        result.put("success", "success");
        if (null == update || update < 1) {
            result.put("success", "warn");
        }
        List<BuyListDto> buys = new ArrayList<BuyListDto>();
        buys.add(buyService.getBuyByBuyno(buyno));
        result.put("buys", buys);
        return result;
    }

    /**
     * 修改采购单信息（采购备注）
     *
     * @param
     * @param request
     * @return
     */
    @PostMapping("change")
    public Map<String, String> change(HttpServletResponse response, HttpServletRequest request,
                                      @RequestParam(value = "buyno") String buyno,
                                      @RequestParam(value = "note", required = false) String note,
                                      @RequestParam(value = "linkLendCostNo", required = false) String linkLendCostNo,
                                      @RequestParam(value = "fileToNull") Boolean fileToNull,
                                      @RequestParam(value = "file", required = false) MultipartFile file) {
        AxiosUtil.setCors(response, request);
        Map<String, String> result = new HashMap<>();

        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setNote(note);
        if (linkLendCostNo != null && !"null".equals(linkLendCostNo)) {
            CostDomain costDomain = costDao.selectByCostNo(linkLendCostNo);
            BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);
            String judgeResult = buyService.judgeLinkLendCost(costDomain, buyByBuyno); // 采购单关联借支单判断
            if (judgeResult != null) {
                result.put("success", "warn");
                result.put("msg", judgeResult);
                return result;
            }
            buyDomain.setLinkLendCostNo(linkLendCostNo);
        }
        if (fileToNull && file == null) {
            buyDomain.setFilepath("");
        }
        if (file != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("buy/" + buyDomain.getBuyno() + "/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(file, filePath);
            buyDomain.setFilepath(path);
        }
        Integer update = buyService.getUpdate(buyDomain);
        if (null == update || update < 1) {
            result.put("success", "warn");
            result.put("msg", "采购单修改失败");
        } else {
            result.put("success", "success");
            result.put("msg", "采购单已修改");
            buyLogService.save(buyno, buyService.getBuyByBuyno(buyno).getCreateuserid(), "修改采购单");
        }
        return result;
    }

    /**
     * 提交财务审核
     *
     * @param request
     * @return
     */
    @GetMapping("tofinance")
    public Map<String, Object> tofinance(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String buyno = request.getParameter("buyno");
        String userid = request.getParameter("userid");
        //  通过 buyno 获取采购单，根据采购单状态采取不同操作
        BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);
        Integer buystatus = buyByBuyno.getBuystatus();
        String linkLendCostNo = buyByBuyno.getLinkLendCostNo();
        String msg = buyByBuyno.getBuystatusDto();
        if (buystatus <= 2) {
            if (linkLendCostNo != null && !"".equals(linkLendCostNo)) {
                CostDomain costDomain = costDao.selectByCostNo(linkLendCostNo);
                // 借支单状态为已支付，借还状态为未还、部分还款
                if (costDomain.getCostStatus() == 4 && (costDomain.getLendStatus() == 1 || costDomain.getLendStatus() == 2)) {
                    msg = buyService.buyLinkLendCost(costDomain, buyByBuyno, Integer.parseInt(userid)); // 采购单关联借支单
                    if (msg.contains("成功")) {
                        BuyDomain buyDomain = new BuyDomain();
                        buyDomain.setBuyno(buyno);
                        buyDomain.setBuystatus(4);
                        buyDomain.setPaystatus(2);
                        buyDomain.setPayTime(new Date());
                        Integer update = buyService.getUpdate(buyDomain);
                        if (null == update && update < 1) {
                            logger.error("更新采购单信息失败，采购单号：" + buyDomain.getBuyno());
                            msg = "更新采购单信息失败";
                        }
                        if (null != update && update >= 1) {
                            //  生成入库表
                            Integer integer = null;
                            integer = storageService.saveStorageByBuy(buyno);
                            if (null == integer && integer < 1) {
                                msg = "生成入库单错误";
                                logger.error("生成入库单错误，采购单号：" + buyno);
                            }
                        }
                        buyLogService.save(buyno, Integer.parseInt(userid), "采购单 " + buyno + "财务审核通过，冲销借支单" + costDomain.getCostNo());
                    }
                } else {
                    msg = "关联的借支单状态异常，不能进行冲销，借支单状态须为已支付，借还状态为未还、部分还款";
                    logger.error("采购单【" + buyno + "】关联的借支单【" + linkLendCostNo + "】状态异常，不能进行冲销，借支单状态须为已支付，借还状态为未还、部分还款");
                }

            } else {
                msg = tofinanceMethod(buyno);
                buyLogService.save(buyno, Integer.parseInt(userid), "采购单 " + buyno + " 财务审核通过，提交出纳审核");
            }
        }

        BuyListDto buyResult = buyService.getBuyByBuyno(buyno);
        List<BuyListDto> buyListDtos = new ArrayList<>();
        buyListDtos.add(buyResult);
        result.put("buys", buyListDtos);
        result.put("msg", msg);

        return result;
    }

    @Resource
    CostUrlProperties costUrlProperties;


    private String tofinanceMethod(String buyno) {

        // 获取采购单信息
        BuyListDto buy = buyService.getBuyByBuyno(buyno);
        // 获取 采购详情 信息
        List<BuyDetailDomain> detailListByBuyno = buyDetailService.getDetailListByBuyno(buyno);
        if (null == detailListByBuyno || detailListByBuyno.size() < 1) {
            return "无采购项目";
        }
        // 获取供货商信息
        SupplierDomain supplier = supplierService.getSupplierByNo(detailListByBuyno.get(0).getSupplierNo());

        //  提交财务
        MultiValueMap<String, Object> requestEntity = new LinkedMultiValueMap<>();
        requestEntity.add("Title", buy.getBuyno());// 申请标题(Title)不可为空；
        requestEntity.add("CompanyMainName", buy.getCompany()); // 公司主体(CompanyMainName)不可为空；
        requestEntity.add("ApplyCallbackUrl", costUrlProperties.purchaseApplyCallbackUrlPost); // 审核回调地址(ApplyCallbackUrl)不可为空；
        requestEntity.add("CashierCallbackUrl", costUrlProperties.purchaseCashierCallbackUrlPost); // 出纳回调地址(CashierCallbackUrl)不可为空；
        requestEntity.add("UnitCode", "CNY"); // 币种编号(UnitCode)不可为空；
        requestEntity.add("UnitName", "人民币"); // 币种名称(UnitName)不可为空；
        requestEntity.add("TradeObjectID", supplier.getSupplierid() + "");
        requestEntity.add("TradeObjectName", supplier.getName()); // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        requestEntity.add("BankNameto", "" + supplier.getBankname());
        requestEntity.add("BankCardto", "" + supplier.getCardno());
        requestEntity.add("BankCardUserto", "" + supplier.getCardusername()); // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        requestEntity.add("SourceCode", "newOtherPurchase");
        requestEntity.add("SourceTypeCode", "newOtherPurchaseType"); // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        requestEntity.add("ApplyType", "" + 1); // 申请类型(ApplyType)不存在；
        requestEntity.add("UserAcctID", "" + buy.getCreateuserid());
        requestEntity.add("UserAcctName", "" + buy.getCreateusername()); // 申请人(UserAcctID/UserAcctName)不存在；
        // 账期 0 PayDay
        requestEntity.add("PayDay", 0);
        // 预计付款时间 ExpectPayTime
        requestEntity.add("ExpectPayTime", new Date());

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        applyMoneyDetail.setName("采购单付款");
        applyMoneyDetail.setMoney(buy.getAmount());
        applyMoneyDetail.setMoneyRmb(buy.getAmount());
        applyMoneyDetail.setRemark("");
        applyMoneyDetailList.add(applyMoneyDetail);

        requestEntity.add("MoneyDetail", applyMoneyDetailList); // 出纳申请金额明细(MoneyDetail)不可为空；

        // 设置 detailKey
        String detailKey = buy.getDetailKey();
        if (null == detailKey || !detailKey.contains("BU")) {
            detailKey = buy.getBuyno();
        }
        requestEntity.add("DetailKey", detailKey); // 回调必要的key参数（DetailKey）不能为空；
        //吴通新增添加SKU大类推送
        requestEntity.add("TypeName", buy.getSkuTypeName());
        Map<String, Object> map = requestEntity.toSingleValueMap();
        String s = JSON.toJSONString(map);
        logger.warn("提交财务审核信息：" + s);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<String> entity = new HttpEntity<String>(s, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(costUrlProperties.postApplyApi, entity, String.class);

        String strBody = null;
        if (null != response && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            strBody = strBody.replace("\\", "");
            strBody = strBody.toLowerCase();
            if (strBody.contains("申请单已存在")) {
                logger.warn("申请单已存在：" + strBody);
                return "申请单已存在";
            } else if (strBody.contains("创建")) {
                //  将 strBody 保存到数据库 tofinance 表
                ObjectMapper mapper = new ObjectMapper();
                try {
                    //  将 strBody 转作为标准 JSONString 格式
                    int i = strBody.lastIndexOf("data\":");
                    String substring1 = strBody.substring(0, i + 6);
                    String substring2 = strBody.substring(i + 7, strBody.length() - 2);
                    strBody = substring1 + substring2 + "}";
                    logger.warn(strBody);
                    ApplyCallbackVo applyCallbackVo = mapper.readValue(strBody, ApplyCallbackVo.class);

                    // 将反馈信息保存到数据库
                    if (null != applyCallbackVo && applyCallbackVo.isSuccess()) {
                        TofinanceDomain tofinanceDomain = new TofinanceDomain();
                        BeanUtils.copyProperties(applyCallbackVo.getData(), tofinanceDomain);
                        tofinanceDomain.setBuyno(buyno);
                        tofinanceDomain.setCode(tofinanceDomain.getCode().toUpperCase());
                        // 执行 insert 流程
                        Integer integer = tofinanceService.saveTofinanceResponse(tofinanceDomain);
                    }
                } catch (IOException e) {
                    logger.error("财务审核申请单信息保存到数据库失败" + strBody);
                }
                return "待出纳付款";
                // 将状态改为 已提交财务审核
//                BuyDomain buyDomain = new BuyDomain();
//                buyDomain.setBuyno(buyno);
                // 判断是否已经自动审核通过
//                BuyDomain buyForUpdate = buyService.getBuyDomain(buyDomain);
//                if (buyForUpdate.getBuystatus() <= 2){
//                    buyDomain.setBuystatus(2);
//                    Integer update = buyService.getUpdate(buyDomain);
//                    logger.info("采购单："+buyno+" 状态已更改：待财务审核 "+update);
//                    return "已提交财务审核";
//                }else {
//                    return "待出纳付款";
//                }
            }
        }
        logger.error(response.getBody());
        return "提交财务审核失败，请稍后重试";
    }


    /**
     * 财务审核回调接口
     *
     * @param request
     * @return
     */
    @PostMapping(value = "ApplyCallbackUrl", consumes = "application/json")
    public String applyCallbackUrl(HttpServletRequest request) {
        String result = null;
        String line = null;
        String buyno = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request) + " ApplyCallbackUrl " + " 财务审核反馈信息获取失败");
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        line = line.replace("\\", "");
        // 格式化为标准 json 格式
        int data = line.lastIndexOf("Data");
        int id = line.lastIndexOf("id");
        String substring1 = line.substring(0, data + 6);
        String substring2 = line.substring(data + 7, id - 4);
        String substring3 = line.substring(id - 3, line.length());
        line = substring1 + substring2 + substring3;
        line = line.toLowerCase();

        //保存为 bean,并且将反馈信息保存到数据库
        ObjectMapper mapper = new ObjectMapper();
        ApplyCallbackUrlVo applyCallbackUrlVo = null;
        try {
            applyCallbackUrlVo = mapper.readValue(line, ApplyCallbackUrlVo.class);
            if (null == applyCallbackUrlVo) {
                logger.error("保存财务审核信息发生错误：" + line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            // 执行保存反馈信息流程
            ApplycallbackDomain applycallbackDomain = new ApplycallbackDomain();
            BeanUtils.copyProperties(applyCallbackUrlVo.getData().getData(), applycallbackDomain);
            buyno = applyCallbackUrlVo.getId().toUpperCase();
            if (null != buyno && buyno.contains("-")) {
                String[] split = buyno.split("-");
                buyno = split[0];
            }
            applycallbackDomain.setBuyno(buyno);
            applycallbackDomain.setMessage(applyCallbackUrlVo.getData().getMessage().toUpperCase());
            applycallbackDomain.setApplyno(applyCallbackUrlVo.getData().getData().getApplyno().toUpperCase());
            Integer integer = applycallbackService.saveApplycallbackResponse(applycallbackDomain);
            logger.warn("保存财务审核信息成功：" + integer + "    " + line);
        } catch (IOException e) {
            logger.error("保存财务审核信息发生错误：" + line);
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        // 获取反馈的审核结果，根据审核结果更改采购单状态
        if (applyCallbackUrlVo.getData().getMessage().contains("通过")) {
            logger.warn(IpUtil.getIpAddr(request) + " ApplyCallbackUrl ：" + line);
            BuyDomain buyDomain = new BuyDomain();
            buyDomain.setBuyno(buyno);
            buyDomain.setBuystatus(3);
            Integer update = buyService.getUpdate(buyDomain);
            if (null == update && update < 1) {
                logger.error("财务审核信息保存失败，请重新提交" + buyDomain.getBuyno());
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
        }

        result = "{result:true,msg:\"\"}";
        return result;
    }


    /**
     * 财务付款回调接口
     *
     * @param request
     * @return
     */
    @PostMapping(value = "CashierCallbackUrl", consumes = "application/json")
    public String cashierCallbackUrl(HttpServletRequest request) {
        String result = null;
        // 将状态改为审核通过、已付款
        logger.warn(IpUtil.getIpAddr(request) + " CashierCallbackUrl ");

        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request) + " CashierCallbackUrl " + " 出纳付款反馈信息获取失败");
        }
        logger.warn("原支付反馈信息：" + line);
        line = line.replace("\\", "");

        // 格式化为标准 json 格式
        int data = line.lastIndexOf("Data");
        int id = line.lastIndexOf("id");
        String substring1 = line.substring(0, data + 6);
        String substring2 = line.substring(data + 7, id - 4);
        String substring3 = line.substring(id - 3, line.length());
        line = substring1 + substring2 + substring3;
        line = line.toLowerCase();
        line = line.replace("_", "");
        logger.warn("支付反馈信息：" + line);

        ObjectMapper mapper = new ObjectMapper();
        CashierCallbackUrlVo cashierCallbackUrlVo = null;
        CashiercallbackDomain cashiercallbackDomain = new CashiercallbackDomain();
        String buyno = null;
        try {
            cashierCallbackUrlVo = mapper.readValue(line, CashierCallbackUrlVo.class);
            if (cashierCallbackUrlVo == null) {
                logger.error("保存出纳付款信息发生错误：" + line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            BeanUtils.copyProperties(cashierCallbackUrlVo.getData(), cashiercallbackDomain);
            BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData(), cashiercallbackDomain);
            BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData().getPaydetail(), cashiercallbackDomain);
            buyno = cashierCallbackUrlVo.getId().toUpperCase();
            if (null != buyno && buyno.contains("-")) {
                String[] split = buyno.split("-");
                buyno = split[0];
            }
            cashiercallbackDomain.setBuyno(buyno);
            cashiercallbackDomain.setMessage(cashiercallbackDomain.getMessage().toUpperCase());
            cashiercallbackDomain.setPayno(cashiercallbackDomain.getPayno().toUpperCase());
            //  保存出纳付款记录
            Integer integer = cashiercallbackService.saveCashiercallbackResponse(cashiercallbackDomain);
            logger.warn("保存出纳付款信息成功：" + integer + "   " + cashiercallbackDomain);
        } catch (IOException e) {
            logger.error("保存出纳付款信息发生错误：" + line);
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        //  付款成功，更改采购单信息，否则返回失败

        /**
         * return
         * result:boolean
         * msg:""
         */
        if (null != cashierCallbackUrlVo && cashierCallbackUrlVo.getData().getMessage().contains("被通过")) {
            logger.warn(IpUtil.getIpAddr(request) + " CashierCallbackUrl ：" + line);
            BuyDomain buyDomain = new BuyDomain();
            buyDomain.setBuyno(buyno);
            buyDomain.setBuystatus(4);
            buyDomain.setPayamount(cashierCallbackUrlVo.getData().getData().getPayamount());
            buyDomain.setPaystatus(2);
            buyDomain.setPayTime(new Date());
            Integer update = buyService.getUpdate(buyDomain);
            // 如果是分批支付的子采购单，更新主采购单分期信息
            if (buyno.contains("X")) {
                buyService.updateInstallment(buyno, cashierCallbackUrlVo.getData().getData().getPayamount());
            }
            if (null == update && update < 1) {
                logger.error("出纳付款信息保存失败，请重新提交" + buyDomain.getBuyno());
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            if (null != update && update >= 1) {
                //  生成入库表（分批支付的采购单 非首期 不进行入库操作）
                if (!buyno.contains("X") || buyno.contains("X1")) {
                    Integer integer = null;
                    integer = storageService.saveStorage(buyno, line);
                    if (null == integer && integer < 1) {
                        result = "{result:false,msg:\"生成入库单错误\"}";
                        logger.error("生成入库单错误：" + buyno);
                        return result;
                    }
                }
                //记录出纳付款日志
                buyLogService.save(buyno, cashierCallbackUrlVo.getData().getData().getPayuserid(), "采购单出纳已付款");
            }
        }
        // 驳回
        if (null != cashierCallbackUrlVo && cashierCallbackUrlVo.getData().getMessage().contains("驳回")) {
            logger.warn(IpUtil.getIpAddr(request) + " CashierCallbackUrl ：" + line);
            BuyDomain buyDomain = new BuyDomain();
            buyDomain.setBuyno(buyno);
            buyDomain.setBuystatus(1);
            buyDomain.setPayamount(cashierCallbackUrlVo.getData().getData().getPayamount());
            buyDomain.setPaystatus(0);
            System.out.println(buyno);
            BuyListDto oldBuy = buyService.getBuyByBuyno(buyno);
            String oldDetailKey = oldBuy.getDetailKey();
            if (null != oldDetailKey && oldDetailKey.contains("-")) {
                String[] split = oldDetailKey.split("-");
                if (null != split && split.length > 1) {
                    Integer i = Integer.parseInt(split[1]) + 1;
                    buyDomain.setDetailKey(split[0] + "-" + i);
                }
            } else {
                buyDomain.setDetailKey(buyno + "-" + 1);
            }
            buyDomain.setRejectReason(cashierCallbackUrlVo.getData().getData().getPaynote());
            Integer update = buyService.getUpdate(buyDomain);
            // 被驳回，改变 detailKey，避免提交出纳系统出现重复异常
//            rejectMethod(cashiercallbackDomain);
            buyLogService.save(buyno, cashierCallbackUrlVo.getData().getData().getPayuserid(), "采购单被出纳驳回：" + cashierCallbackUrlVo.getData().getData().getPaynote());
        }
        result = "{result:true,msg:\"\"}";
        return result;
    }
//
//    private void rejectMethod(CashiercallbackDomain cashiercallbackDomain) {
//        String oldBuyno = cashiercallbackDomain.getBuyno();
//        String newBuyno = "";
//        if (null != oldBuyno && !oldBuyno.contains("-")){
//            newBuyno = oldBuyno+"-1";
//        }
//        if (null != oldBuyno && oldBuyno.contains("-")){
//            String[] ss = oldBuyno.split("-");
//            newBuyno = ss[0]+"-"+(Integer.parseInt(ss[1])+1);
//        }
//        // 1 采购单号
//        Integer r1 = buyService.updateNewBuyno(oldBuyno,newBuyno);
//        // 2 采购子项目的采购单号变更
//        Integer r2 = buyDetailService.updateNewBuyno(oldBuyno,newBuyno);
//        // 3 日志采购单号变更
//        Integer r3 = buyLogService.updateNewBuyno(oldBuyno,newBuyno);
//    }

    @PostMapping("savePd")
    public Map<String, Object> savePd(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String storageno = request.getParameter("storageno");
        String buyno = request.getParameter("buyno");
        String pdno = request.getParameter("pdno");
        String sender = request.getParameter("sender");
        String recipients = request.getParameter("recipients");
        String sendstatusStr = request.getParameter("sendstatus");
        Integer sendstatus = Integer.parseInt(sendstatusStr);

        // 入库表信息修改
        StorageDomain storageDomain = new StorageDomain();
        storageDomain.setStorageno(storageno);
        storageDomain.setPhysicalDistributionNo(pdno);
        storageDomain.setSender(sender);
        storageDomain.setRecipients(recipients);
        storageDomain.setSendstatus(sendstatus);

        // 采购单信息修改,判断发货状态是否为已发货，并将采购单信息改为发货入库中
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setSendstatus(sendstatus);
        if (0 == sendstatus) {
            buyDomain.setBuystatus(4);
            storageDomain.setBuystatus(4);
        }
        if (1 == sendstatus) {
            buyDomain.setBuystatus(5);
            storageDomain.setBuystatus(5);
        }
        // 判断是否为签收，已签收则根据 sku 修改库存信息,并且将采购单信息改为已入库
        if (2 == sendstatus) {
            buyDomain = buyService.getBuyDomain(buyDomain);
            buyDomain.setBuystatus(6);
            storageDomain.setBuystatus(6);

            List<BuyDetailDomain> detailListByBuyno = buyDetailService.getDetailListByBuyno(buyno);
            if (null != detailListByBuyno && detailListByBuyno.size() >= 1) {
                for (BuyDetailDomain domain : detailListByBuyno) {
                    buyDomain.setSkucode(domain.getSkucode());
                    buyDomain.setSkuname(domain.getSkuname());
                    buyDomain.setCount(domain.getCount());
                    buyDomain.setAmount(domain.getAmount());
                    buyDomain.setPayamount(domain.getAmount());
                    // 获取库存记录   仓库+sku 双维度
                    InventoryDomain inventorybySkucode = inventoryService.getByWarehouseidAndSkucode(buyDomain.getWarehouseid(), domain.getSkucode());
                    InventoryDomain inventoryDomain = null;
                    // 存在库存记录则改变库存
                    if (null != inventorybySkucode && null != inventorybySkucode.getId()) {
                        Integer numBefore = inventorybySkucode.getInventoryNum();
                        Integer inventoryNum = numBefore + domain.getCount();
                        inventoryDomain = inventoryService.update(inventorybySkucode, inventoryNum);
                        logger.info("仓库：" + buyDomain.getWarehousename() + "  已经存在 sku 编号为 " + domain.getSkucode() + " 的库存记录，库存改为 " + inventoryNum);
                        InventoryLogDto inventoryLogDto = inventoryLogService.saveInventoryLog(buyDomain, numBefore, inventoryNum);
                        result.put("inventoryLog", inventoryLogDto);
                    }
                    // 不存在库存记录则添加记录
                    if (null == inventorybySkucode || null == inventorybySkucode.getId()) {
                        logger.info("新增 sku 编号为 " + domain.getSkucode() + " 库存记录");
                        inventoryDomain = inventoryService.saveInventory(buyDomain);
                        // 保存库存变更日志
                        InventoryLogDto inventoryLogDto = inventoryLogService.saveInventoryLog(buyDomain, 0, buyDomain.getCount());
                        result.put("inventoryLog", inventoryLogDto);
                    }
                }
            }
            result.put("inventory", null);
            result.put("sendstatus", 2);
        }

        Integer storageUpdate = storageService.update(storageDomain);
        BuyDomain buy = new BuyDomain();
        buy.setBuyno(buyDomain.getBuyno());
        buy.setBuystatus(buyDomain.getBuystatus());
        buy.setSendstatus(sendstatus);
        Integer buyUpdate = buyService.getUpdate(buy);

//        BuyListDto buyByBuyno = buyService.getBuyByBuyno(buyno);

        result.put("storageUpdate", storageUpdate);
        result.put("buyUpdate", buyUpdate);
//        result.put("buy",buyByBuyno);
        return result;
    }

    /**
     * 废弃采购单
     *
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/delBuy")
    public Map<String, Object> delBuy(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String buyno = request.getParameter("buyno");
        String userid = request.getParameter("userid");
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyno);
        buyDomain.setBuystatus(100);
        Integer update = buyService.getUpdate(buyDomain);
        if (buyno.contains("X")) {
            buyService.deleteInstallment(buyno);
        }
        if (null != update && 1 == update) {
            Map<String, Object> result = new HashMap<>();
            result.put("success", true);
            buyLogService.save(buyno, Integer.parseInt(userid), "采购单 " + buyno + " 已作废");
            return result;
        }
        return null;
    }

    @GetMapping("/getBuyLogs")
    public Map<String, Object> getCostLogs(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String buyNo = request.getParameter("buyNo");
        List<String> buyLogs = buyLogService.getListLogs(buyLogService.getListByBuyno(buyNo));
        Map<String, Object> result = new HashMap<>();
        result.put("buyLogs", buyLogs);
        return result;
    }

    /**
     * 设置分期信息
     *
     * @param response
     * @param request
     * @param payment
     * @return
     */
    @PostMapping("/setInstallment")
    public Map<String, Object> setInstallment(HttpServletResponse response, HttpServletRequest request, @RequestParam(value = "buyNo") String buyNo,
                                              @RequestParam(value = "payment") BigDecimal payment) {
        AxiosUtil.setCors(response, request);
        buyService.setInstallment(buyNo, payment);
        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        return result;
    }

    /**
     * 提前完结分期采购单
     *
     * @param response
     * @param request
     * @param buyNo
     * @return
     */
    @GetMapping("/closeBuy")
    public Map<String, Object> closeBuy(HttpServletResponse response, HttpServletRequest request, @RequestParam(value = "buyNo") String buyNo) {
        AxiosUtil.setCors(response, request);
        BuyDomain buyDomain = new BuyDomain();
        buyDomain.setBuyno(buyNo);
        buyDomain.setBuystatus(4);
        buyDomain.setPaystatus(1);
        buyService.getUpdate(buyDomain);
        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        return result;
    }
}
