package com.blt.other.module.cost.controller;

import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.dto.response.RestResp;
import com.blt.other.module.cost.dto.response.SaveResp;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.cost.service.impl.costplan.CostPlanServiceFactory;
import com.blt.other.database.model.CostPlanDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Api(tags = "费用计划接口")
@RestController
@RequestMapping(value = {"/cost/plan/"})
public class CostPlanNewController {


    @ApiOperation("获取新增费用计划编号")
    @GetMapping("/getNo")
    public Map<String, Object> getNo() {

        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService();
        String no = costPlanService.createNo();
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanNo", no);
        result.put("success", true);
        return result;
    }


    @ApiOperation("确认费用计划")
    @PostMapping("/affirm")
    public Map<String, Object> affirm(@RequestParam String costPlanNo) {
        Map<String, Object> result = new HashMap<>();
        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanNo);

        Integer affirm = costPlanService.affirm(costPlanNo);
        result.put("success", true);
        result.put("msg", "已生成 " + affirm + " 张费用单");

        return result;
    }

    @ApiOperation("/删除费用计划")
    @PostMapping("/deleted")
    public Map<String, Object> deleted(@RequestParam String costPlanNo) {
        Map<String, Object> result = new HashMap<>();
        try {
            CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanNo);
            costPlanService.deleted(costPlanNo);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "发生错误");
        }
        return result;
    }

    @ApiOperation("更新费用计划")
    @PostMapping(value = {"/reset"})
    public RestResp reset(@RequestBody CostPlanDomain costPlanDomain) {
        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanDomain);
        costPlanService.update(costPlanDomain);

        RestResp resp = new RestResp();
        resp.setSuccess(true);
        resp.setMsg("已经修改");
        return resp;
    }

    @ApiOperation("新增费用计划")
    @PostMapping(value = {"/save"})
    public SaveResp save(@RequestBody CostPlanDomain costPlanDomain) {
        CostPlanService costPlanService = CostPlanServiceFactory.getCostPlanService(costPlanDomain);

        costPlanService.save(costPlanDomain);
        SaveResp resp = new SaveResp();
        resp.setCostPlanDomain(costPlanDomain);
        resp.setCostPlanNo(costPlanDomain.getCostPlanNo());
        resp.setMsg("success");
        resp.setSuccess(true);
        return resp;
    }

    @PostMapping("/changeDic")
    public Map<String, Object> changeDic(HttpServletResponse response,
                                         HttpServletRequest request) {
        Map<String, Object> result = new HashMap<>();

        String fromDic = request.getParameter("fromDic");
        String toDic = request.getParameter("toDic");

        String payCounteractStr = request.getParameter("payCounteract").replace(" ", "");
        String payLendBalanceStr = request.getParameter("payLendBalance").replace(" ", "");

        BigDecimal payCounteract;
        if (!payCounteractStr.isEmpty()) {
            payCounteract = new BigDecimal(payCounteractStr);
        } else {
            payCounteract = new BigDecimal(0);
        }
        BigDecimal payLendBalance;
        if (!payLendBalanceStr.isEmpty()) {
            payLendBalance = new BigDecimal(payLendBalanceStr);
        } else {
            payLendBalance = new BigDecimal(0);
        }


        BigDecimal cur = CurUtils.getCur(fromDic, toDic);

        BigDecimal counteract = payCounteract.multiply(cur);
        BigDecimal lendBalance = payLendBalance.multiply(cur);
        BigDecimal planAmount = counteract.add(lendBalance);
        BigDecimal payPlanAmount = payCounteract.add(payLendBalance);
        result.put("success", true);
        result.put("counteract", counteract.setScale(2, BigDecimal.ROUND_HALF_UP));
        result.put("lendBalance", lendBalance);
        result.put("planAmount", planAmount.setScale(2, BigDecimal.ROUND_HALF_UP));
        result.put("payPlanAmount", payPlanAmount);
        result.put("cur", cur);
        return result;
    }

}
