package com.blt.other.module.commons.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class FinansysDetailDtoData {
    private Integer id;
    @JsonProperty
    private String DepartmentName;
    @JsonProperty
    private String ApplyUserName; //申请人
    @JsonProperty
    private String BuyNo;//采购单编号
    @JsonProperty
    private String Important;//是否紧急
    //    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @JsonProperty
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date ApplyTime; //申请时间
    @JsonProperty
    private Integer PayType; //出纳类型，1：付款，2：收款
    @JsonProperty
    private String CompanyFullName; //单位全称
    @JsonProperty
    private String SettleAccount;//结账方式
    @JsonProperty
    private String CompanyName;//单位名称
    @JsonProperty
    private String PayWay; //付款方式
    @JsonProperty
    private String Account;//帐号
    @JsonProperty
    private String Remark; //理由
    @JsonProperty
    private String UnitCode; //币种
    @JsonProperty
    private BigDecimal Amount; //金额
    @JsonProperty
    private String ChineseAmount; //中文金额
    @JsonProperty
    private String CWOperationer;//财务
    @JsonProperty
    private String DepartmentManager;//负责人
    @JsonProperty
    private String PayCompany;//付款主体
    @JsonProperty
    private BigDecimal TaxFee; //增值税点
    @JsonProperty
    private BigDecimal TaxPrice; //含税价
    @JsonProperty
    private String PayDay;//付款方式，有账期
    @JsonProperty
    private String StorageTime;//采购单入库时间
    @JsonProperty
    private String AllStorageTime; //采购单完整入库时间
    @JsonProperty
    private String SupplierName; //供应商名称
    @JsonProperty
    private String UserName; //姓名
    @JsonProperty
    private String BankName; //银行名称
    @JsonProperty
    private String BankCard; //银行卡号
    @JsonProperty
    private BigDecimal BalanceAmount; //余额
    @JsonProperty
    private String TaoBaoOrderNo;
    @JsonProperty
    private List ListLog; // 日志

}
