package com.blt.other.module.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaDepartmentServiceImpl extends ServiceImpl<OaDepartmentMapper, OaDepartment> implements IOaDepartmentService {
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public List<OaDepartment> primaryDepartment(@NonNull Integer companyId) {
        return this.list(new LambdaQueryWrapper<OaDepartment>()
                .eq(OaDepartment::getParentId, 0)
                .eq(OaDepartment::getCompanyId, companyId));
    }

    @Override
    public void modifyDepartmentReviewer(Integer userId, Integer oaDepartmentId, List<Integer> departmentReviewerUserIds) {
        OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
        OaDepartment oaDepartment = baseMapper.selectByDepartmentId(oaDepartmentId);

        //记录更新时间
        oaDepartment.setLastUpdateTime(LocalDateTime.now());
        oaDepartment.setUpdateUserId(userId);
        oaDepartment.setUpdateUserName(currentOaUser.getUserName());
        baseMapper.updateById(oaDepartment);

        //删除旧审核人
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                .eq(CostReviewer::getReferId, oaDepartmentId));


        //新增审核人
        departmentReviewerUserIds.forEach(departmentReviewerUserId -> {
            //新增审核人
            OaUser departmentReviewerOaUser = oaUserMapper.selectByOaUserId(departmentReviewerUserId);

            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(departmentReviewerUserId)
                    .reviewerUserName(departmentReviewerOaUser.getUserName())
                    .referId(oaDepartmentId)
                    .type(CostReviewer.departmentReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);
        });
    }

    @Override
    public void updateDepartmentMinimumReviewAmount(Integer oaDepartmentId, BigDecimal amount) {
        OaDepartment oaDepartment = baseMapper.selectByDepartmentId(oaDepartmentId);
        oaDepartment.setDepartmentMinimumReviewAmount(amount);
        baseMapper.updateById(oaDepartment);
    }

    @Override
    public List<OaDepartment> allOaDepartment() {
        return baseMapper.allOaDepartment();
    }
}
