package com.blt.other.module.auth.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.blt.other.module.sys.model.CostReviewer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OaCompany对象", description = "")
public class OaCompany implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private Integer oaCompanyId;

    private String name;

    private String code;
    private Integer createUserId;
    private String createUserName;

    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime createTime;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty("更新用户id")
    private Integer updateUserId;
    @ApiModelProperty("更新用户姓名")
    private String updateUserName;

    @ApiModelProperty("最终审核人")
    @TableField(exist = false)
    private CostReviewer finalReviewer;

    @ApiModelProperty("财务审核人")
    @TableField(exist = false)
    private CostReviewer financialReviewer;
}
