package com.blt.other.module.sys.dto.response;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.blt.other.module.sys.model.CostReviewer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/21 9:38 上午
 */
@Data
public class DepartmentReviewerListItem {


    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "一级部门id")
    private Integer primaryDepartmentId;

    @ApiModelProperty(value = "一级部门")
    private String primaryDepartmentName;

    @ApiModelProperty(value = "二级部门id")
    private Integer secondDepartmentId;

    @ApiModelProperty(value = "二级部门")
    private String secondDepartmentName;

    @ApiModelProperty(value = "自动审核金额")
    private BigDecimal autoReviewAmount;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最近一次更新时间")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty(value = "更新人id")
    private Integer updateUserId;

    @ApiModelProperty(value = "更新人")
    private String updateUserName;

    private List<CostReviewer> costReviewerList;

}
