package com.blt.other.module.cost.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.cost.api.dto.LogisticsFinansysDto;
import com.bailuntec.cost.api.dto.SubLogisticsFinansysDto;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.UserCostFinansysDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.UserCostFinansysService;
import com.blt.other.module.cost.vo.UserCostFinansysVo;
import com.blt.other.module.cost.vo.UserFinansysVo;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import com.blt.other.database.model.UserDomain;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service
public class UserCostFinansysServiceImpl implements UserCostFinansysService {

    @Autowired
    private UserCostFinansysDao userCostFinansysDao;

    @Autowired
    private UserDao userDao;


    @Override
    public Integer saveFinansysRecord(UserCostFinansysDomain userCostFinansysDomain) {
        UserCostFinansysDomain byUserCostFinansysDetail = getByUserCostFinansysDetail(userCostFinansysDomain);
        if (null != byUserCostFinansysDetail && null != byUserCostFinansysDetail.getUserCostFinansysNo()) {
            return null;
        }
        return userCostFinansysDao.insert(userCostFinansysDomain);
    }

    @Override
    public UserCostFinansysDomain createFinansyRecordByCostPlanDomain(CostPlanDomain planDomain) {
        CostDomain costDomain = new CostDomain();
        BeanUtils.copyProperties(planDomain, costDomain);
        return setParams(costDomain);
    }

    @Override
    public UserCostFinansysDomain createFinansyRecordByCostDomain(CostDomain costDomain) {
        return setParams(costDomain);
    }

    private UserCostFinansysDomain setParams(CostDomain cost) {
        UserCostFinansysDomain userCostFinansysDomain = new UserCostFinansysDomain();
        UserDomain user = userDao.select(cost.getCreateUsercode());
        userCostFinansysDomain.setUsercode(user.getUsercode());
        userCostFinansysDomain.setUseraccount(user.getUseraccount());
        userCostFinansysDomain.setUsername(user.getUsername());
        userCostFinansysDomain.setUserid(user.getUserid());
        userCostFinansysDomain.setBankName(cost.getBankName());
        userCostFinansysDomain.setBankCard(cost.getBankCard());
        userCostFinansysDomain.setBankCardUser(cost.getBankCardUser());
        userCostFinansysDomain.setBankCompany(cost.getBankCompany());
        userCostFinansysDomain.setUserCostFinansysNo(createNo());
        return userCostFinansysDomain;
    }


    @Override
    public UserCostFinansysDomain getByUserCostFinansysNo(String userCostFinansysNo) {
        return userCostFinansysDao.selectByNo(userCostFinansysNo);
    }

    @Override
    public UserCostFinansysDomain getByUserCostFinansysDetail(UserCostFinansysDomain userCostFinansysDomain) {
        return userCostFinansysDao.selectByDetail(userCostFinansysDomain);
    }

    @Override
    public List<UserCostFinansysDomain> getAllFinansysRecord() {
        List<UserCostFinansysDomain> list = userCostFinansysDao.selectAll();
        return list;
    }

    /**
     * 同步财务信息
     *
     * @return
     */
    @Override
    public String syncUserFinansys() {
        // 1、获取 page=1  pagesize=25 ，并得到总条数
        UserFinansysVo userFinansysVo = getUserFinansysVo(1, 25);
        Integer total = userFinansysVo.getTotal();
        // 2、 获取总页数
        int result = 0;
        int update = 0;
        if (null != total && total >= 1) {
            int pageNum = 1;
            for (pageNum = 1; pageNum <= ((total / 25) + 1); pageNum++) {
                List<UserCostFinansysVo> vos = getUserCostFinansysList(pageNum, 25);
                if (null != vos && vos.size() >= 1) {
                    for (UserCostFinansysVo vo : vos) {
                        if (3 == vo.getStatus() && 13 == vo.getCategoryid()) {
                            Integer insert = insertUserFinansys(vo);
                            if (null != insert && 1 == insert)
                                result += 1;
                            if (null != insert && 0 == insert)
                                update += 1;
                        }
                    }
                }
            }
        }
        return "新增 " + result + " 条记录，新增 " + update + " 条记录";
    }

    /**
     * 根据 userid 获取财务信息
     *
     * @param
     * @return
     */
    @Override
    public List<UserCostFinansysDomain> getByUserid(int userid) {
        return userCostFinansysDao.selectByUserid(userid);
    }

    /**
     * 保存/修改从财务系统获取的财务信息
     *
     * @param vo
     * @return
     */
    private Integer insertUserFinansys(UserCostFinansysVo vo) {
        UserCostFinansysDomain userCostFinansysDomain = userCostFinansysDao.selectByBankInfo(vo.getBankname(), vo.getCardno(), vo.getCardusername(), vo.getCardusername());
        if (userCostFinansysDomain == null) {
            userCostFinansysDomain = new UserCostFinansysDomain();
            userCostFinansysDomain.setSyncId(vo.getId());
            userCostFinansysDomain.setUserid(vo.getCreateuserid());
            userCostFinansysDomain.setUsername(vo.getCreateusername());
            userCostFinansysDomain.setUseraccount(vo.getUsername());
            userCostFinansysDomain.setBankName(vo.getBankname());
            userCostFinansysDomain.setBankCardUser(vo.getCardusername());
            userCostFinansysDomain.setBankCard(vo.getCardno());
            userCostFinansysDomain.setBankCompany(vo.getCardusername());
            userCostFinansysDomain.setUserCostFinansysNo(createNo());
            userCostFinansysDao.insert(userCostFinansysDomain);
            return 1;
        } else {
            userCostFinansysDomain.setSyncId(vo.getId());
            userCostFinansysDomain.setUserid(vo.getCreateuserid());
            userCostFinansysDomain.setUsername(vo.getCreateusername());
            userCostFinansysDomain.setUseraccount(vo.getUsername());

            userCostFinansysDao.updateById(userCostFinansysDomain);
            return 0;

        }
    }

    @Resource
    CostUrlProperties costUrlProperties;

    private List<UserCostFinansysVo> getUserCostFinansysList(Integer pageNum, Integer pageSize) {
        RestTemplate restTemplate = new RestTemplate();
        String url = costUrlProperties.getSupplierPageListApi + "?page=" + pageNum + "&pagesize=" + pageSize + "&key";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);
        if (response.getStatusCodeValue() == 200) {
            String strBody = response.getBody();
            JSONObject jsonObject = JSON.parseObject(strBody);
            String resultStr = String.valueOf(jsonObject.get("list"));
            return JsonUtilByFsJson.jsonToList(resultStr, UserCostFinansysVo.class);
        }
        return null;
    }

    private UserFinansysVo getUserFinansysVo(Integer pageNum, Integer pageSize) {
        RestTemplate restTemplate = new RestTemplate();
        String url = costUrlProperties.getSupplierPageListApi + "?page=" + pageNum + "&pagesize=" + pageSize + "&key";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);

        String strBody;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            return (UserFinansysVo) MyMapperUtil.getObject(strBody, UserFinansysVo.class);
        }

        return null;
    }

    private String createNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String no = "UCF" + sdf.format(new Date());

        UserCostFinansysDomain userCostFinansysDomain = userCostFinansysDao.selectByNo(no);
        while (null != userCostFinansysDomain && null != userCostFinansysDomain.getUserCostFinansysNo()) {
            no = "UCF" + sdf.format(new Date());
            userCostFinansysDomain = userCostFinansysDao.selectByNo(no);
        }
        return no;
    }

    @Override
    public List<LogisticsFinansysDto> getAllLogisticsFinansys() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity<String> response = restTemplate.getForEntity(costUrlProperties.getAllLogisticsFinansysApi, String.class);
        String strBody;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            return JSONObject.parseArray(strBody, LogisticsFinansysDto.class);
        }
        return null;
    }

    @Override
    public List<SubLogisticsFinansysDto> getAllSubLogisticsFinansys() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity<String> response = restTemplate.getForEntity(costUrlProperties.getAllSubLogisticsFinansysApi, String.class);
        String strBody = null;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            List<SubLogisticsFinansysDto> subLogistics = JSONObject.parseArray(strBody, SubLogisticsFinansysDto.class);
            return subLogistics;
        }
        return null;
    }

}
