package com.blt.other.module.cost.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.CostTypeAddReq;
import com.blt.other.module.cost.dto.request.CostTypeModifyReq;
import com.blt.other.module.cost.dto.request.CostTypeQueryPageReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.service.CostTypeService;
import com.blt.other.database.model.CostTypeDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

@Service
@Slf4j
public class CostTypeServiceImpl extends ServiceImpl<CostTypeDao, CostTypeDomain> implements CostTypeService {
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public void addCostType(CostTypeAddReq req) {
        CostTypeDomain costTypeDomain = new CostTypeDomain();
        costTypeDomain.setAccountingSubjectNo(req.getAccountingSubjectNo());
        costTypeDomain.setTypeNo(req.getTypeNo());
        costTypeDomain.setTypeName(req.getTypeName());
        costTypeDomain.setDescription(req.getDescription());

        costTypeDomain.setCostTemplateType(req.getType());

        this.save(costTypeDomain);
    }

    @Override
    public Page<CostTypeResult> queryPage(CostTypeQueryPageReq req) {
        IPage<CostTypeResult> page = new Page<>(req.getPageNum(), req.getPageSize());

        req.setCostTemplateType(this.getCostTemplateType((req.getType())));
        page = baseMapper.queryPage(page, req);
        return (Page<CostTypeResult>) page;
    }

    @Override
    public void modifyCostType(CostTypeModifyReq req) {
        OaUser oaUser = oaUserMapper.selectByOaUserId(req.getCurrentUserId());


        log.info("{} 更新费用类型", oaUser.getUserName());
        if (req.getTypeNo() != null) {
            CostTypeDomain costTypeDomain = baseMapper.selectByNo(req.getTypeNo());
            costTypeDomain.setTypeName(req.getTypeName().trim());
            costTypeDomain.setDescription(req.getDescription());
            costTypeDomain.setUpdateUserId(oaUser.getOaUserId());
            costTypeDomain.setUpdateUser(oaUser.getUserName());
            costTypeDomain.setLastUpdateTime(LocalDateTime.now());
            this.updateById(costTypeDomain);
        }

        log.info("{} 更新会计一级科目", oaUser.getUserName());
        if (req.getAccountingSubjectNo() != null) {
            AccountingSubject accountingSubject = accountingSubjectMapper.selectByNo(req.getAccountingSubjectNo());
            accountingSubject.setName(req.getAccountingSubjectName().trim());
            accountingSubject.setLastUpdateTime(LocalDateTime.now());
            accountingSubject.setUpdateUserId(oaUser.getOaUserId());
            accountingSubject.setUpdateUser(oaUser.getUserName());
            accountingSubject.setLastUpdateTime(LocalDateTime.now());
            accountingSubjectMapper.updateById(accountingSubject);
        }
    }

    /**
     * 根据ui类型获取费用类型 对应的费用模版类型
     *
     * @param type 1-费用类型 2-收入类型
     * @return res
     */
    private Integer getCostTemplateType(Integer type) {
        if (type.equals(1)) {
            return CostTypeDomain.feeType;
        } else if (type.equals(2)) {
            return CostTypeDomain.incomeType;
        } else {
            throw new BizRuntimeException("invalid type");
        }
    }

}
