package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.cost.dto.request.CostTypeAddReq;
import com.blt.other.module.cost.dto.request.CostTypeModifyReq;
import com.blt.other.module.cost.dto.request.CostTypeQueryPageReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.database.model.CostTypeDomain;

public interface CostTypeService extends IService<CostTypeDomain> {

    /**
     * 添加费用类型
     *
     * @param req req
     */
    void addCostType(CostTypeAddReq req);


    /**
     * 分页获取费用类型
     *
     * @param req req
     * @return resp
     */
    Page<CostTypeResult> queryPage(CostTypeQueryPageReq req);

    /**
     * 更新费用类型 （费用类型 或者 会计科目类型）
     *
     * @param req req
     */
    void modifyCostType(CostTypeModifyReq req);
}
