package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.CostTypeAddReq;
import com.blt.other.module.cost.dto.request.CostTypeModifyReq;
import com.blt.other.module.cost.dto.request.CostTypeQueryPageReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.cost.service.CostTypeService;
import com.blt.other.database.model.LogisticsSupplierBankDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Api(tags = "费用类型接口")
@RestController
@RequestMapping("/cost/type")
public class CostTypeController {
    @Resource
    private CostTypeKindService costTypeKindService;
    @Resource
    private CostTypeService costTypeService;

    @ApiOperation("分页获取费用类型")
    @PostMapping("/queryPage")
    public CostResult<Page<CostTypeResult>> queryPage(@RequestBody CostTypeQueryPageReq req) {
        log.info("分页获取费用类型");
        Page<CostTypeResult> page = costTypeService.queryPage(req);
        return CostResult.success(page);
    }

    @ApiOperation("添加费用类型")
    @PostMapping("/addCostType")
    public CostResult<Void> addCostType(@RequestBody CostTypeAddReq req) {
        log.info("添加费用类型");
        costTypeService.addCostType(req);
        return CostResult.success();
    }

    @ApiOperation("更新费用类型（费用类型 或者 会计科目类型）")
    @PostMapping("/modifyCostType")
    public CostResult<Void> modifyCostType(@RequestBody CostTypeModifyReq req) {
        log.info("更新费用类型（费用类型 或者 会计科目类型）");
        costTypeService.modifyCostType(req);
        return CostResult.success();
    }

    @ApiOperation("获取物流subjectCode")
    @GetMapping("/getLogisticsCode")
    public Map<String, Object> getLogisticsCode() {
        log.info("获取物流subjectCode");
        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        result.put("logisticsCode", "22222");
        return result;
    }

    @ApiOperation("获取物流银行帐号")
    @PostMapping("/getLogisticsBank")
    public Map<String, Object> getLogisticsBank(@RequestParam String subSupplierName) {
        Map<String, Object> result = new HashMap<>();
        LogisticsSupplierBankDomain bankDomain = costTypeKindService.getLogisticsBank(subSupplierName);
        if (bankDomain != null) {
            result.put("success", true);
            result.put("bankInfo", bankDomain);
        } else {
            result.put("success", false);
        }
        return result;
    }
}
