package com.blt.other.module.cost.controller;

import com.blt.other.module.cost.dto.request.AddItemReq;
import com.blt.other.module.cost.dto.request.AddItemResp;
import com.blt.other.module.cost.dto.request.ResetItemReq;
import com.blt.other.module.cost.dto.response.DeleteItemResp;
import com.blt.other.module.cost.dto.response.GetByTempNoResp;
import com.blt.other.module.cost.dto.response.GetCostTempByPlanNoResp;
import com.blt.other.module.cost.dto.response.ResetItemResp;
import com.blt.other.module.cost.service.CostPlanTempService;
import com.blt.other.database.model.CostPlanTempDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.math.BigDecimal;

@Api(tags = "费用计划接口")
@RestController
@RequestMapping("/cost/plan/temp")
@Slf4j
public class CostPlanTempController {
    @Autowired
    private CostPlanTempService costPlanTempService;

    @ApiOperation(value = "保存无附件费用计划子项")
    @PostMapping(value = {"/addItem"})
    public AddItemResp addItem(AddItemReq req) {
        try {
            return costPlanTempService.doSave(req);
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            AddItemResp resp = new AddItemResp();
            resp.setSuccess(false);
            resp.setMsg(ex.getMessage());
            return resp;
        }
    }

    @ApiOperation("获取费用计划编号对应的费用计划子项")
    @GetMapping("/getCostTempByPlanNo")
    public GetCostTempByPlanNoResp getCostTempByPlanNo(@RequestParam String costPlanNo) {
        return costPlanTempService.getTempListByPlanNo(costPlanNo);
    }

    @ApiOperation("删除费用计划子项")
    @PostMapping("/deleteItem")
    public DeleteItemResp deleteItem(@RequestParam String costPlanNo,
                                     @RequestParam String tempNo) {


        BigDecimal planAmount = costPlanTempService.deleteItemByPlanNoAndTempNo(costPlanNo, tempNo);
        DeleteItemResp resp = new DeleteItemResp();
        resp.setSuccess(true);
        resp.setMsg("success");
        resp.setPlanAmount(planAmount);
        return resp;
    }

    @ApiOperation("根据费用计划模板编号获取费用计划模版")
    @GetMapping("/getByTempNo")
    public GetByTempNoResp getByTempNo(@RequestParam String tempNo) {
        CostPlanTempDomain domain = costPlanTempService.getByTempNo(tempNo);
        GetByTempNoResp resp = new GetByTempNoResp();
        resp.setTmp(domain.castToDto());
        return resp;
    }

    @ApiOperation("更新费用项")
    @PostMapping(value = {"/resetItem/noFile", "/resetItem/file"})
    public ResetItemResp resetNoFile(ResetItemReq req) {

        CostPlanTempDomain tmp = costPlanTempService.resetItem(req);
        ResetItemResp resp = new ResetItemResp();
        resp.setSuccess(true);
        resp.setTmp(tmp);
        return resp;
    }


    @ApiOperation("下载费用单项附件")
    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(@RequestParam String tempNo) throws IOException {

        CostPlanTempDomain temp = costPlanTempService.getByTempNo(tempNo);
        String filePath = temp.getFilePath();
        String fileName = null;

        if (null != filePath) {
            String[] split = filePath.split("&");
            if (split.length >= 1) {
                fileName = split[split.length - 1];
            }
        }

        assert filePath != null;
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

}
