package com.blt.other.module.auth.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.auth.model.OaDepartment;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface OaDepartmentMapper extends BaseMapper<OaDepartment> {

    /**
     * <p>
     * 获取部门审核人配置列表
     * </p>
     *
     * @return 部门审核人列表
     */
    IPage<DepartmentReviewerListItem> reviewerList(@Param("page") IPage<DepartmentReviewerListItem> page,
                                                   @Param("req") DepartmentReviewerListReq req);

    OaDepartment selectByDepartmentId(Integer oaDepartmentId);
}
