package com.bailuntec.cost.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
public class CostDto {

    private Integer id; // 费用单表 id
    private String costNo; // 费用单编号
    private String costPlanNo; // 费用计划编号
    private String companyNo; // 主体编号
    private String companyName; // 主体名称
    private String typeNo; // 大类编号
    private String typeName; // 大类标题
    private String kindNo; // 小类编号
    private String kindName; // 小类标题
    private Integer createUserid; // 创建人 id
    private String createUsercode; // 创建人编号
    private String createUsername; // 创建人名称
    private String costRemark; // 费用单备注
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime; // 创建时间
    private String sonCostNo; // 关联子单
    private String supCostNo; // 关联父单
    private Integer costStatus; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String costStatusDto; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String filePath; // 文件地址
    private String fileName; // 文件名
    private String morFilePath; // 补充材料地址
    private String morFileName; // 补充材料文件名
    private BigDecimal amount; // 费用总金额
    private String amountDto;
    private Integer subLogisticsSupplierId; // 二级物流供应商ID
    private Integer logisticsSupplierId; // 一级物流供应商ID
    private String bankName; // 收款银行（平台）
    private String bankCard; // 收款账户
    private String bankCardUser; // 收款用户名
    private String bankCompany; // 收款/付款单位
    private String morRemark; // 补充信息
    private Integer isLend; // 0 普通费用  1 借支  2 借还
    private String isLendDto;// 0 普通费用  1 借支  2 借还
    private Integer costForm; // 费用类型
    private String costFormDto; // 费用类型
    private String costReason; // 付款理由
    private BigDecimal hadPay; // 借支单已还金额
    private Integer lendStatus; // 借支单状态 1 未还 2 部分还款  3 结清
    private String lendStatusDto;
    private BigDecimal compensate; // 借支单补偿金额
    private BigDecimal counteract; // 冲销金额
    private BigDecimal lendBalance; // 借还单余额
    private String rejectReason; // 驳回原因
    private String dic; // 币种
    private String dicDto; // 币种
    private BigDecimal payCounteract; // 借还单冲销金额 ( 支付币种 )
    private BigDecimal payLendBalance; // 借还单余额 （ 支付币种 ）
    private BigDecimal payPlanAmount; // 计划金额 （ 支付币种 ）
    private String payPlanAmountDto;
    private String payDic; // 支付币种
    private String payDicDto; // 支付币种
    private BigDecimal payCur; // 汇率
    private Integer isTax; // 0 不抵扣个税  1 抵扣个税
    private String isTaxStr; // 0 不抵扣个税  1 抵扣个税
    private String detailKey; // 出纳系统 detailKey
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date payTime; // 付款时间
    private Integer hasInvoice;
    private Integer rejectType;
    private Integer rejectTime;
    private String cashierFilePath;
    private String cashierDownloadPath;

    //费用来源 1-默认 2-WMS 3-调拨系统
    private String sourceFrom;
    //项目
    private String projectType;
    //客户编号
    private String customerNum;
    @TableField(exist = false)
    private Integer primaryDepartmentId;
    @TableField(exist = false)
    private String primaryDepartmentName;

    @ApiModelProperty("能否审核")
    @TableField(exist = false)
    private Boolean canAudit;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;

    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;

    @TableField(exist = false)
    private CostTemplateDto costTemplate;

    private LocalDateTime lastModifyDate;

    ///-------------

    @ApiModelProperty("科目编号")
    private String subjectCode;

    @ApiModelProperty("支付者用户ID")
    private Integer payUserId;

    @ApiModelProperty("转人民币汇率")
    private BigDecimal toRmbRate;

    @ApiModelProperty("费用单人民币总金额")
    private BigDecimal amountRmb;

    @ApiModelProperty("公司主体value")
    private Integer companyValue;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("财务审核时间")
    private Date auditTime;

    @ApiModelProperty("借支单，还款申请金额，包括已还的和申请中 ，借支单币种。")
    private BigDecimal repaymentAppliedAmount;


}
