package com.blt.other.cost.service.impl;

import com.blt.other.auth.dao.UserDao;
import com.blt.other.cost.dao.CostLogDao;
import com.blt.other.cost.service.CostLogService;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.UserDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class CostLogServiceImpl implements CostLogService {

    @Autowired
    private CostLogDao costLogDao;
    @Autowired
    private UserDao userDao;

    @Override
    public Integer save(String costNo, Integer updateuserid, String updateMainNote) {
        CostLogDomain costLog = new CostLogDomain();
        costLog.setCostNo(costNo);
        costLog.setUpdateTime(new Date());

        UserDomain user = userDao.selectByuserid(updateuserid);
        costLog.setUpdateUsercode(user.getUsercode());
        costLog.setUpdateUserid(updateuserid);
        costLog.setUpdateUsername(user.getUsername());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        costLog.setUpdateNote(sdf.format(costLog.getUpdateTime())+"  "+updateMainNote+"  更新人："+user.getUsername());

        return costLogDao.insert(costLog);
    }

    @Override
    public List<CostLogDomain> getListByCostNo(String costNo) {
        return costLogDao.selectByCostNo(costNo);
    }

    @Override
    public List<String> getListLogs(List<CostLogDomain> logs) {
        if (null != logs && logs.size() >= 1){
            List<String> list = new ArrayList<>();
            for (CostLogDomain domain: logs){
                list.add(domain.getUpdateNote());
            }
            return list;
        }
        return null;
    }
}
