package com.blt.other.cost.controller.costplan;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.CurUtils;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.cost.utils.CostPlanUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "借还单接口")
@RestController
@RequestMapping("/cost/plan/new/lend2")
public class CostPlanNewLend2Controller {


    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    /**
     * 保存借还单计划  不带附件
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/saveNoFile")
    public Map<String, Object> saveNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlan = CostPlanUtils.createCostPlan(request, costPlanNo);
        this.doSaveFinansyRecord(costPlan);
        costPlanService.save(costPlan);

        try {
            result.put("msg", "费用单已创建");
            result.put("costPlan", costPlan);
            result.put("costPlanNo", costPlan.getCostPlanNo());
            return result;
        } catch (Exception ex) {
            return result;
        }
    }

    /**
     * 保存借还单  带附件
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/saveFile")
    public Map<String, Object> saveFile(HttpServletResponse response, HttpServletRequest request, @RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlanDomain = CostPlanUtils.createCostPlan(request, costPlanNo);
        Integer finansyRecord = doSaveFinansyRecord(costPlanDomain);
        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costPlanDomain.getCostPlanNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);

        costPlanDomain.setFilePath(path);
        costPlanService.save(costPlanDomain);

        try {

            result.put("costPlan", costPlanDomain);
            result.put("msg", "费用单已创建");
            result.put("costPlanNo", costPlanDomain.getCostPlanNo());
            return result;
        } catch (Exception ex) {
            result.put("msg", "费用单创建失败");
            result.put("costNo", null);
        }
        return result;
    }

    @PostMapping("/changeDic")
    public Map<String, Object> changeDic(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String fromDic = request.getParameter("fromDic");
        String payCounteractStr = request.getParameter("payCounteract");
        payCounteractStr = payCounteractStr.replace(" ", "");
        BigDecimal payCounteract = null;
        if (!payCounteractStr.isEmpty()) {
            payCounteract = new BigDecimal(payCounteractStr);
        } else {
            payCounteract = new BigDecimal(0);
        }
        String payLendBalanceStr = request.getParameter("payLendBalance");
        payLendBalanceStr = payLendBalanceStr.replace(" ", "");
        BigDecimal payLendBalance = null;
        if (null != payLendBalanceStr && !payLendBalanceStr.isEmpty()) {
            payLendBalance = new BigDecimal(payLendBalanceStr);
        } else {

            payLendBalance = new BigDecimal(0);
        }


        String toDic = request.getParameter("toDic");

        BigDecimal cur = CurUtils.getCur(fromDic, toDic, getExchangeRateApi);

        BigDecimal counteract = payCounteract.multiply(cur);
        BigDecimal lendBalance = payLendBalance.multiply(cur);
        BigDecimal planAmount = counteract.add(lendBalance);
        BigDecimal payPlanAmount = payCounteract.add(payLendBalance);
        result.put("success", true);
        result.put("counteract", counteract.setScale(2, BigDecimal.ROUND_HALF_UP));
        result.put("lendBalance", lendBalance);
        result.put("planAmount", planAmount.setScale(2, BigDecimal.ROUND_HALF_UP));
        result.put("payPlanAmount", payPlanAmount);
        result.put("cur", cur);
        return result;
    }

    /**
     * 保存填写的财务信息
     *
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        return userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
    }
}
