package com.blt.other.cost.controller;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.MyMapperUtil;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.service.CostExportService;
import com.blt.other.cost.service.CostLogService;
import com.blt.other.cost.service.CostService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.cost.utils.CostUtils;
import com.blt.other.cost.vo.CostExportVo;
import com.blt.other.cost.vo.CostResp;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.CostExpDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "费用单接口")
@RestController
@RequestMapping("cost/list/")
public class CostListController {

    @Autowired
    private CostService costService;
    @Autowired
    private UserCostFinansysService userCostFinansysService;
    @Autowired
    private CostExportService costExportService;
    @Autowired
    private CostLogService costLogService;

    @ApiOperation("获取所有费用单")
    @GetMapping("/getAllCost")
    public Map<String, Object> getAllCost(@RequestParam Integer pageNum,
                                          @RequestParam Integer pageSize,
                                          @RequestParam Integer userId,
                                          @RequestParam(defaultValue = "0", required = false) Integer authType,
                                          @RequestParam(required = false) String projectTypes) {
        if (authType != 0) {
            userId = null;
        }
        Map<String, Object> result = costService.getAllCost(pageNum, pageSize, userId, projectTypes);
        result.put("success", true);
        return result;
    }

    @ApiOperation("获取费用详情")
    @PostMapping("/getCostDetail")
    public CostResp.GetCostDetailResp getCostDetail(@RequestParam String costNo) {
        CostResp.GetCostDetailResp resp = new CostResp.GetCostDetailResp();

        CostDomain costDomain = costService.getCostByCostNo(costNo);
        resp.setMsg("success");
        resp.setCost(costDomain.castToDto());
        return resp;
    }

    @ApiOperation("修改发票附件")
    @PostMapping("reset/resetInvoice")
    public Map<String, Object> resetInvoice(@RequestParam String costNo,
                                            @RequestParam("fileSelect") MultipartFile file) {

        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setHasInvoice(1);
        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        costDomain.setFilePath(path);
        Map<String, Object> map = costService.upadateCost(costDomain);
        costLogService.save(costNo, costService.getCostDomainByNo(costNo).getCreateUserid(), "修改发票信息");
        map.put("success", true);
        return map;
    }


    /**
     * 信息修改，带附件
     *
     * @param response
     * @param request
     * @param file
     * @return
     */
    @PostMapping("reset/resetFile")
    public Map<String, Object> resetFile(HttpServletResponse response, HttpServletRequest request, @RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        CostDomain costDomain = CostUtils.createCostDomain(request, costNo);
        boolean saveRecord = saveRecord(costDomain);
        if (saveRecord) {
            Integer integer = doSaveFinansyRecord(costDomain);
        }
        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        costDomain.setFilePath(path);
        Map<String, Object> map = costService.upadateCost(costDomain);
        costLogService.save(costNo, costService.getCostDomainByNo(costNo).getCreateUserid(), "修改费用单");
        map.put("success", true);
        return map;
    }


    @ApiOperation("信息修改，不带附件")
    @PostMapping("reset/resetNoFile")
    public Map<String, Object> resetNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        CostDomain costDomain = CostUtils.createCostDomain(request, request.getParameter("costNo"));
        boolean saveRecord = saveRecord(costDomain);
        if (saveRecord) {
            Integer integer = doSaveFinansyRecord(costDomain);
        }

        Map<String, Object> map = costService.upadateCost(costDomain);
        costLogService.save(costDomain.getCostNo(), costService.getCostDomainByNo(costDomain.getCostNo()).getCreateUserid(), "修改费用单");
        map.put("success", true);
        return map;
    }

    @PostMapping("submitAudit")
    public Map<String, Object> submitAudit(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        CostDomain costDomainByNo = costService.getCostDomainByNo(costNo);
        costDomainByNo.setCostStatus(1);

        Map<String, Object> map = costService.upadateCost(costDomainByNo);
        costLogService.save(costNo, costDomainByNo.getCreateUserid(), "提交费用单");
        return map;
    }

    /**
     * 获取借支单列表
     *
     * @param request
     * @param response
     * @return
     */
    @GetMapping("/getAllLendCost")
    public Map<String, Object> getAllLendCost(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        String createuserid = request.getParameter("createuserid");
        Map<String, Object> result = new HashMap<>();
        List<CostDto> costDtos = costService.getLinkLendCost(Integer.valueOf(createuserid));

        result.put("success", true);
        result.put("lends", costDtos);
        result.put("msg", "");
        return result;
    }

    @PostMapping("/getCostByCostPlanNo")
    public Map<String, Object> getCostByCostPlanNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        Map<String, Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        List<CostDto> costDtos = costService.getByCostPlanNo(costPlanNo);

        result.put("costs", costDtos);
        return result;
    }

    /**
     * 保存填写的财务信息
     *
     * @return
     */
    private Integer doSaveFinansyRecord(CostDomain costDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }

    /**
     * 判断是否存在相同记录
     *
     * @param costDomain
     * @return
     */
    private boolean saveRecord(CostDomain costDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        UserCostFinansysDomain byUserCostFinansysDetail = userCostFinansysService.getByUserCostFinansysDetail(finansyRecordByCostDomain);
        if (null != byUserCostFinansysDetail && null != byUserCostFinansysDetail.getId()) {
            return false;
        } else {
            return true;
        }
    }

    @PostMapping("/deleted")
    public Map<String, Object> deleted(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costNo = request.getParameter("costNo");
        Integer set = costService.setStatus(costNo, 5);
        if (null != set && set >= 1) {
            result.put("success", true);
            costLogService.save(costNo, costService.getCostDomainByNo(costNo).getCreateUserid(), "作废费用单");
        }
        return result;
    }

    @PostMapping("/exportList")
    public String exportList(HttpServletResponse response, HttpServletRequest request) throws IOException {
        AxiosUtil.setCors(response, request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            String filePath = costExportService.exportFees(costExportVo.getParams().getExportNos());
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @PostMapping("/exportListAll")
    public String exportListAll(HttpServletResponse response, HttpServletRequest request) throws IOException {
        AxiosUtil.setCors(response, request);
        Enumeration<String> parameterNames = request.getParameterNames();

        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            List<String> exportNos;
            if (null != costExportVo.getParams().getKeys().getCostForm() && 3 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setIsLend(1);
            }
            if (null != costExportVo.getParams().getKeys().getCostForm() && 4 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setCostForm(3);
                costExportVo.getParams().getKeys().setIsLend(2);
            }
            List<String> costNo = costService.listCostNoAll(costExportVo);
            exportNos = costNo;
            String filePath = costExportService.exportFees(exportNos);
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String pathNo = request.getParameter("pathNo");
        CostExpDomain exp = costExportService.getByExpNo(pathNo);
        String filePath = exp.getExpPath();
        String fileName = PathUtil.getFileName(filePath);
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("downloadCashierAnnex")
    public ResponseEntity<InputStreamResource> downCashierAnnex(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String detailNo = request.getParameter("detailNo");
        CostDomain cost = costService.getByNo(detailNo);
        String filePath = null;
        String fileName = null;
        if (null != cost) {
            filePath = cost.getCashierFilePath();
            if (null != filePath) {
                fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
