package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.service.CostService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.cost.utils.CostUtils;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("cost/list/add/")
public class CostListAddController {

    private static Logger logger = LoggerFactory.getLogger(CostListAddController.class);

    @Autowired
    private CostService costService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    /**
     * 保存费用单（带附件）
     *
     * @param response
     * @param request
     * @param file
     * @return
     */
    @PostMapping("affirmFile")
    public Map<String, Object> affirmFile(HttpServletResponse response,
                                          HttpServletRequest request,
                                          @RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costNo = CostUtils.getIdNum(costService);
        CostDomain costDomainByNo = costService.getCostDomainByNo(costNo);
        while (null != costDomainByNo && null != costDomainByNo.getId()) {
            costNo = CostUtils.getIdNum(costService);
        }
        CostDomain costDomain = CostUtils.createCostDomain(request, costNo);

        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);

        costDomain.setFilePath(path);
        // 保存表单中的银行卡信息
        if (hasRecord(costDomain)) {
            Integer finansyRecord = doSaveFinansyRecord(costDomain);
        }
        Integer integer = costService.saveNewCost(costDomain);

        if (null != integer && integer >= 1) {
            result.put("msg", "费用单已创建");
            result.put("costNo", costDomain.getCostNo());
            result.put("costDomain", costDomain);
            return result;
        }
        result.put("msg", "费用单创建失败");
        result.put("costNo", null);

        return result;
    }

    /**
     * 保存费用单（不带附件）
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("affirmNoFile")
    public Map<String, Object> affirmNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costNo = CostUtils.getIdNum(costService);
        CostDomain costDomainByNo = costService.getCostDomainByNo(costNo);
        while (null != costDomainByNo && null != costDomainByNo.getId()) {
            costNo = CostUtils.getIdNum(costService);
        }
        CostDomain costDomain = CostUtils.createCostDomain(request, costNo);
        // 保存表单中的银行卡信息
        if (hasRecord(costDomain)) {
            Integer finansyRecord = doSaveFinansyRecord(costDomain);
        }
        Integer integer = costService.saveNewCost(costDomain);
        if (null != integer && integer >= 1) {
            result.put("msg", "费用单已创建");
            result.put("costNo", costDomain.getCostNo());
            return result;
        }
        result.put("msg", "费用单已创建");
        result.put("costNo", costDomain.getCostNo());
        result.put("costDomain", costDomain);
        return result;
    }

    /**
     * 保存填写的财务信息
     *
     * @return
     */
    private Integer doSaveFinansyRecord(CostDomain costDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }

    /**
     * 判断是否需要记录财务信息
     *
     * @param costDomain
     * @return
     */
    private boolean hasRecord(CostDomain costDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostDomain(costDomain);
        UserCostFinansysDomain byUserCostFinansysDetail = userCostFinansysService.getByUserCostFinansysDetail(finansyRecordByCostDomain);
        if (null != byUserCostFinansysDetail && null != byUserCostFinansysDetail.getId()) {
            return false;
        } else {
            // 判断是否是付款费用或借支单
            if (1 == costDomain.getCostForm()) {
                return true;
            } else if (2 == costDomain.getCostForm()) {
                return false;
            } else {
                if (1 == costDomain.getIsLend()) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
}
