package com.blt.other.cost.config;


import com.blt.other.cost.job.CostCompanySyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 主体更新定时器配置
 */
@Configuration
public class CostCompanySyncConfiguration {

    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail costCompanySyncJobJobDetail(){
        return JobBuilder.newJob(CostCompanySyncJob.class)
                .withIdentity("costCompanySyncJob")
                .storeDurably()
                .build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger costCompanySyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(costCompanySyncJobJobDetail())
                .withIdentity("costCompanySuncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
