package com.blt.other.module.auth.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.blt.other.module.sys.model.CostReviewer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OaDepartment对象", description = "")
public class OaDepartment implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "oa部门id")
    private Integer departmentId;

    @ApiModelProperty(value = "oa部门编码")
    private String code;

    @ApiModelProperty(value = "oa公司主体id")
    private Integer companyId;

    @TableField(exist = false)
    private String companyName;

    private String manageUser1;

    private String manageUser2;

    private Integer parentId;

    @ApiModelProperty(value = "部门名称")
    private String name;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "创建人id")
    private Integer createUserId;
    @ApiModelProperty(value = "创建人姓名")
    private String createUserName;


    @ApiModelProperty("部门全名")
    private String fullName;

    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime createTime;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty("更新用户id")
    private Integer updateUserId;
    @ApiModelProperty("更新用户姓名")
    private String updateUserName;

    private BigDecimal departmentMinimumReviewAmount;

    @TableField(exist = false)
    private List<CostReviewer> costReviewerList;


    @TableField(exist = false)
    @ApiModelProperty("子节点")
    private List<OaDepartment> childList;


}
