package com.blt.other.module.entrepot.service;

import com.blt.other.module.database.model.BuyDomain;
import com.blt.other.module.database.model.InventoryLogDomain;
import com.blt.other.module.entrepot.dto.InventoryLogDto;

import java.util.Map;

public interface InventoryLogService {

    /**
     * 保存库存变更日志
     * @param buyDomain
     * @return
     */
    InventoryLogDto saveInventoryLog(BuyDomain buyDomain,Integer numBefore,Integer numLater);

    /**
     * 保存库存变更日志
     * @param inventoryLogDomain
     * @return
     */
    InventoryLogDto save(InventoryLogDomain inventoryLogDomain);

    /**
     * 根据库存编号获取库存日志列表
     * @param inventoryNo
     * @return
     */
    Map<String,Object> getInventoryLogsByInventoryNo(String inventoryNo,Integer pageNum,Integer pageSize) ;
}
