package com.blt.other.sku.dao;

import com.blt.other.database.model.SysProductDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface SysProductDao {
    /**
     * 获取所有的 sku
     * @return
     */
    List<SysProductDomain> selectAll();

    /**
     * 根据 keyword 查询 sku
     */
    List<SysProductDomain> selectByKeyword(@Param("key") String keyword);

    /**
     *  根据 skucode 获取 sku
     * @param skucode
     * @return
     */
    SysProductDomain selectBySkucode(String skucode);

    /**
     * 修改 sku 信息
     * @param sysProductDomain
     * @return
     */
    Integer update(SysProductDomain sysProductDomain);

    /**
     * 新增 sku
     * @param sku
     * @return
     */
    Integer insert(SysProductDomain sku);

    /**
     * 删除 sku
     * @param skucode
     * @return
     */
    Integer delete(String skucode);

    Integer deleteBySupplierNo(String supplierNo);
}
