package com.blt.other.purchasing.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
@Data
public class PurcharseListSearchKeysVo {
    //    {"pageNum":1,"pageSize":5,"company":"COM1806191800016","warehouseid":"WH1810221515446","createuserid":2346,"buystatus":1,"sendstatus":0,"beginTime":"2018-10-09","endTime":"2018-10-31"}
    private Integer pageNum;
    private Integer pageSize;
    private String company;
    private String warehouseid;
    private Integer createuserid;
    private Integer buystatus;
    private Integer sendstatus;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date beginTime;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date endTime;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date payBeginTime;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date payEndTime;
    /**
     * 采购单查找类型
     * 1、普通采购单
     * 2、分期子采购单
     * 3、分期主采购单
     * 4、分期主采购单+分期子采购单
     * 5、普通采购单+分期子采购单
     * 6、普通采购单+分期主采购单
     */
    private Integer buySearchType;
}
