package com.blt.other.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.cost.dao.CostTemplateMapper;
import com.blt.other.cost.model.CostTemplate;
import com.blt.other.cost.model.CostTemplateCol;
import com.blt.other.cost.service.ICostTemplateColService;
import com.blt.other.cost.service.ICostTemplateService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 费用单模版 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateServiceImpl extends ServiceImpl<CostTemplateMapper, CostTemplate> implements ICostTemplateService {

    @Resource
    ICostTemplateColService costTemplateColService;

    @Override
    public void add(CostTemplate costTemplate) {
        this.save(costTemplate);
        costTemplate.getCostTemplateColList().forEach(costTemplateCol -> costTemplateCol.setCostTemplateId(costTemplate.getId()));
        costTemplateColService.saveBatch(costTemplate.getCostTemplateColList());
    }

    @Override
    public CostTemplate queryDetail(Integer id) {
        CostTemplate costTemplate = this.getById(id);
        List<CostTemplateCol> costTemplateColList = costTemplateColService.list(new LambdaQueryWrapper<CostTemplateCol>()
                .eq(CostTemplateCol::getCostTemplateId, id));

        costTemplate.setCostTemplateColList(costTemplateColList);
        return costTemplate;
    }

    @Override
    public void edit(CostTemplate costTemplate) {
        this.save(costTemplate);
        List<CostTemplateCol> costTemplateColList = costTemplate.getCostTemplateColList();
        costTemplateColList.forEach(costTemplateCol -> costTemplateCol.setCostTemplateId(costTemplate.getId()));
        costTemplateColService.saveBatch(costTemplateColList);
    }

    @Override
    public void delete(Integer id) {
        if (id != null) {
            this.removeById(id);
            costTemplateColService.remove(new LambdaQueryWrapper<CostTemplateCol>()
                    .eq(CostTemplateCol::getCostTemplateId, id));
        }

    }
}
