package com.blt.other.cost.dao;

import com.blt.other.database.model.CostPlanTempDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostPlanTempDao {

    CostPlanTempDomain selectByNo(String tempNo);

    Integer insert(CostPlanTempDomain costPlanTempDomain);

    CostPlanTempDomain selectByPlanNoAndKindNo(@Param("costPlanNo") String costPlanNo, @Param("kindNo") String kindNo);

    List<CostPlanTempDomain> selectListByPlanNo(String costPlanNo);

    Integer deletedByPlanNoAndTempNo(@Param("costPlanNo") String costPlanNo, @Param("tempNo") String tempNo);

    Integer update(CostPlanTempDomain domain);

    void deletedFilePath(String tempNo);

    List<CostPlanTempDomain> selectByPlanNoAndTypeNo(@Param("costPlanNo") String costPlanNo, @Param("typeNo") String typeNo);

    CostPlanTempDomain selectByPlanNoAndTempNo(@Param("costPlanNo") String costPlanNo, @Param("tempNo") String tempNo);
}
