package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.MyMapperUtil;
import com.blt.other.cost.service.CostListSearchService;
import com.blt.other.cost.vo.CostListSearchKeysVo;
import com.blt.other.database.model.CostDomain;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;


@Api(tags = "费用搜索接口")
@RestController
@RequestMapping("cost/list")
public class CostListSearchController {

    @Autowired
    private CostListSearchService costListSearchService;

    @PostMapping("/search/key")
    public Map<String, Object> getByKey(HttpServletResponse response,
                                        HttpServletRequest request) {

        AxiosUtil.setCors(response, request);
        String key = request.getParameter("key");
        String pageNumStr = request.getParameter("pageNum");
        String pageSizeStr = request.getParameter("pageSize");

        Map<String, Object> map = costListSearchService.searchByKey(key, Integer.parseInt(pageNumStr), Integer.parseInt(pageSizeStr));
        map.put("success", true);
        return map;
    }

    @PostMapping("/search/keys")
    public Map<String, Object> getByKeys(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            Object object = MyMapperUtil.getObject(s, CostListSearchKeysVo.class);
            CostListSearchKeysVo searchKeysVo = (CostListSearchKeysVo) object;
            if (null != searchKeysVo.getParams().getKeys().getCostForm() && 3 == searchKeysVo.getParams().getKeys().getCostForm()) {
                searchKeysVo.getParams().getKeys().setIsLend(1);
            }
            if (null != searchKeysVo.getParams().getKeys().getCostForm() && 4 == searchKeysVo.getParams().getKeys().getCostForm()) {
                searchKeysVo.getParams().getKeys().setCostForm(3);
                searchKeysVo.getParams().getKeys().setIsLend(2);
            }
            Map<String, Object> result = costListSearchService.searchByKeys(searchKeysVo);
            result.put("success", true);
            return result;
        }
        return null;
    }

    @GetMapping("/search/getLinkCost")
    public List<CostDomain> getLinkCost(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return costListSearchService.getLinkCost();
    }
}
