package com.blt.other.supplier.service.impl;

import com.blt.other.auth.dao.UserDao;
import com.blt.other.database.model.SupplierDomain;
import com.blt.other.sku.dao.SkuTypeDao;
import com.blt.other.sku.dao.SysProductDao;
import com.blt.other.supplier.dao.BuyUserDao;
import com.blt.other.supplier.dao.SupplierDao;
import com.blt.other.supplier.service.SupplierService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class SupplierServiceImpl implements SupplierService {
    private static Logger logger = LoggerFactory.getLogger(SupplierServiceImpl.class);

    @Autowired
    private SupplierDao supplierDao;
    @Autowired
    private BuyUserDao buyUserDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SkuTypeDao skuTypeDao;
    @Autowired
    private SysProductDao sysProductDao;

    @Override
    public SupplierDomain getSupplierByid(Integer supplierid) {
        return supplierDao.select(supplierid);
    }

    @Override
    public Map<String,Object> getAllSupplier(Integer page,Integer pageSize) {
        PageHelper.startPage(page,pageSize);
        Map<String,Object> map = new HashMap<>();

        List<SupplierDomain> supplierDomains = supplierDao.selectALlSupplier();
        PageInfo<SupplierDomain> pageInfo = new PageInfo<>(supplierDomains);

        map.put("suppliers",supplierDomains);
        map.put("pageInfo",pageInfo);

        return map;
    }

    /**
     * 新增供应商
     * @param supplierDomain
     * @return
     */
    @Override
    public Integer saveSupplier(SupplierDomain supplierDomain) {
        supplierDomain.setSupplierNo(createSupplierNo());
        supplierDomain.setCreateusername((userDao.selectByuserid(supplierDomain.getCreateuserid())).getUsername());
        supplierDomain.setSkuTypeName((skuTypeDao.selectBySkuTypeNo(supplierDomain.getSkuTypeNo())).getSkuTypeName());
        Integer integer = supplierDao.insert(supplierDomain);
        return integer;
    }

    /**
     * 根据 name 和 skuTypeNo 获取供应商信息
     * @param name
     * @param skuTypeNo
     * @return
     */
    @Override
    public List<SupplierDomain> getByNameAndSkuTypeNo(String name, String skuTypeNo) {
        SupplierDomain supplierDomain = new SupplierDomain();
        supplierDomain.setName(name);
        supplierDomain.setSkuTypeNo(skuTypeNo);
        List<SupplierDomain> supplierDomains = supplierDao.selectBySupplierNameAndSkuTypeNo(supplierDomain);
        return supplierDomains;
    }

    @Override
    public Map<String, Object> getAllSuppliers() {
        Map<String,Object> map = new HashMap<>();
        List<SupplierDomain> supplierDomains = supplierDao.selectALlSupplier();
        map.put("suppliers",supplierDomains);
        return map;
    }

    /**
     * 根据 supplierNo 获取供应商
     * @param supplierNo
     * @return
     */
    @Override
    public SupplierDomain getSupplierByNo(String supplierNo) {
        SupplierDomain supplierDomain = supplierDao.selectBySupplierNo(supplierNo);
        return supplierDomain;
    }

    @Override
    public  List<SupplierDomain> getSupplierBySkuTypeNo(String skuTypeNo) {
        List<SupplierDomain> supplierDomains = supplierDao.selectBySkuTypeNo(skuTypeNo);
        return supplierDomains;
    }

    @Override
    public Integer deleteSup(String supplierNo) {
        Integer result =  supplierDao.delete(supplierNo);
        // 删除供应商后，清空供应商的 sku 信息
        Integer delSku = sysProductDao.deleteBySupplierNo(supplierNo);
        return result;
    }

    @Override
    public Integer update(SupplierDomain supplier) {
        return supplierDao.update(supplier);
    }

    /**
     * 生成唯一供应商编号
     */
    private String createSupplierNo(){
        String supplierNo = null;
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        supplierNo = "SU"+sdf.format(new Date())+random.nextInt(9);
        SupplierDomain supplierDomain = supplierDao.selectBySupplierNo(supplierNo);
        while (null != supplierDomain && null != supplierDomain.getSupplierNo()){
            supplierNo = "STN"+sdf.format(new Date())+random.nextInt(9);
            supplierDomain = supplierDao.selectBySupplierNo(supplierNo);
        }
        return supplierNo;
    }
}
