package com.blt.other.supplier.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.database.model.SupplierDomain;
import com.blt.other.supplier.service.SupplierSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("supplier/search")
public class SupplierSearchController {

    @Autowired
    private SupplierSearchService supplierSearchService;
    @PostMapping("")
    public Map<String,Object> key(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String searchKey = request.getParameter("searchKey");
        Map<String,Object> result = new HashMap<>();
        List<SupplierDomain> byKey = supplierSearchService.getByKey(searchKey);
        result.put("success",true);
        result.put("suppliers",byKey);
        return result;
    }

    @PostMapping("/supplierNo")
    private Map<String,Object> getSupplierByNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String supplierNo = request.getParameter("supplierNo");
        SupplierDomain supplier = supplierSearchService.getBySupplierNo(supplierNo);
        Map<String,Object> result = new HashMap<>();
        result.put("success",true);
        result.put("supplier",supplier);
        return result;
    }
}
