package com.blt.other.cost.service.impl;

import com.bailuntec.common.BeanUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.cost.dao.CostTemplateBaseColMapper;
import com.blt.other.cost.dto.CostTemplateColReq;
import com.blt.other.cost.model.CostTemplateBaseCol;
import com.blt.other.cost.service.ICostTemplateBaseColService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 费用单基础字段 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateBaseColServiceImpl extends ServiceImpl<CostTemplateBaseColMapper, CostTemplateBaseCol> implements ICostTemplateBaseColService {

    @Override
    public List<CostTemplateBaseCol> listAll() {
        return this.list();
    }

    @Override
    public void add(CostTemplateColReq.AddReq req) {
        if (!req.getIsExtension()) {
            throw new RuntimeException("只能添加扩展字段");
        }
        CostTemplateBaseCol costTemplateBaseCol = new CostTemplateBaseCol();
        BeanUtils.copyProperties(req, costTemplateBaseCol);
        this.save(costTemplateBaseCol);
    }
}
