package com.blt.other.cost.service.impl;

import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.commons.utils.CurUtils;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.dao.CostPlanDao;
import com.blt.other.cost.dao.CostPlanTempDao;
import com.blt.other.cost.dao.CostTypeKindDao;
import com.blt.other.cost.dto.CostPlanTempApiDto;
import com.blt.other.cost.service.CostPlanTempService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.CostPlanTempDomain;
import com.blt.other.database.model.CostTypeKindDomain;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

@Service
public class CostPlanTempServiceImpl implements CostPlanTempService {

    @Autowired
    private CostPlanTempDao costPlanTempDao;

    @Autowired
    private CostTypeKindDao costTypeKindDao;

    @Autowired
    private CostPlanDao costPlanDao;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Override
    public String createNo() {

        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        String no = "CPT" + sdf.format(new Date()) + random.nextInt(9);
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByNo(no);
        while (null != costPlanTempDomain && null != costPlanTempDomain.getCostPlanNo()) {
            no = "CPT" + sdf.format(new Date()) + random.nextInt(9);
            costPlanTempDomain = costPlanTempDao.selectByNo(no);
        }
        return no;
    }

    /**
     * 检查同一个付款计划中是否存在大类相同、币种不同的情况
     *
     * @param costPlanTempDomain 费用计划
     */
    private void checkDic(CostPlanTempDomain costPlanTempDomain) {
        List<CostPlanTempDomain> checkDict = this.getListByPlanNoAndTypeNo(costPlanTempDomain.getCostPlanNo(),
                costPlanTempDomain.getTypeNo());
        if (checkDict.stream().collect(Collectors.groupingBy(CostPlanTempDomain::getTypeNo)).keySet().size() > 1) {
            throw new RuntimeException("已存在相同大类，请保持币种一致！")
        }
    }


    @Override
    public CostPlanTempApiDto.AddItemResp doSave(CostPlanTempApiDto.AddItemReq req) {

        CostPlanTempDomain costPlanTempDomain = new CostPlanTempDomain();
        BeanUtils.copyProperties(req, costPlanTempDomain);

        this.checkDic(costPlanTempDomain);

        /*附件字段*/
        if (req.getFileSelect() != null) {
            // 文件上传的路径
            String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costPlanTempDomain.getTempNo() + "/");
            // 调用工具类执行保存，并返回 path
            String path = CostFileUtil.upload(req.getFileSelect(), filePath);
            costPlanTempDomain.setFilePath(path);
        }
        //新增付款子项目
        costPlanTempDao.insert(costPlanTempDomain);

        // 添加付款子项目成功，计划单改变总额
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanTempDomain.getCostPlanNo());
        costPlanDomain.setPlanAmount(costPlanDomain.getPlanAmount().add(costPlanTempDomain.getAmount()));
        costPlanDao.update(costPlanDomain);

        CostPlanTempApiDto.AddItemResp resp = new CostPlanTempApiDto.AddItemResp();
        resp.setMsg("success");
        resp.setPlaAmount(CurUtils.getCur(costPlanTempDomain.getDic(), "CNY", getExchangeRateApi));
        resp.setTmp(costPlanTempDomain);
        resp.setSuccess(true);
        return resp;
    }


    @Override
    public CostPlanTempApiDto.GetCostTempByPlanNoResp getTempListByPlanNo(String costPlanNo) {
        List<CostPlanTempDomain> list = costPlanTempDao.selectListByPlanNo(costPlanNo);
        List<CostPlanTempDto> dtoList = null;
        if (null != list && list.size() >= 1) {
            dtoList = new ArrayList<>();
            for (CostPlanTempDomain costPlanTempDomain : list) {
                dtoList.add(domainToDto(costPlanTempDomain));
            }
        }
        return dtoList;
    }

    @Override
    public Integer deleteItemByPlanNoAndTempNo(String costPlanNo, String tempNo) {
//        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByPlanNoAndKindNo(costPlanNo, kindNo);
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByPlanNoAndTempNo(costPlanNo, tempNo);
        if (null == costPlanTempDomain || null == costPlanTempDomain.getTempNo()) {
            return null;
        }
        Integer result = costPlanTempDao.deletedByPlanNoAndTempNo(costPlanNo, tempNo);
        if (null != result && result >= 0) {
            // 删除付款子项目成功，计划单改变总额
            CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanTempDomain.getCostPlanNo());
            if (null != costPlanDomain && null != costPlanDomain.getCostPlanNo()) {
                if (null == costPlanDomain.getPlanAmount()) {
                    costPlanDomain.setPlanAmount(new BigDecimal(0));
                }
                costPlanDomain.setPlanAmount(costPlanDomain.getPlanAmount().subtract(costPlanTempDomain.getAmount()));
                Integer update = costPlanDao.update(costPlanDomain);
            }
            return result;
        }
        return null;
    }

    @Override
    public CostPlanTempDomain getByTempNo(String tempNo) {
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByNo(tempNo);
        if (null != costPlanTempDomain && null != costPlanTempDomain.getId()) {
            return costPlanTempDomain;
        }
        return null;
    }

    @Override
    public Integer update(CostPlanTempDomain domain) {
        Integer update = costPlanTempDao.update(domain);
        return update;
    }

    @Override
    public void deleteFilePath(String tempNo) {
        costPlanTempDao.deletedFilePath(tempNo);
    }

    @Override
    public List<CostPlanTempDomain> getListByPlanNoAndTypeNo(String costPlanNo, String typeNo) {
        return costPlanTempDao.selectByPlanNoAndTypeNo(costPlanNo, typeNo);
    }

    @Override
    public CostPlanTempDomain getByPlanNoAndTempNo(String costPlanNo, String tempNo) {
        return costPlanTempDao.selectByPlanNoAndTempNo(costPlanNo, tempNo);
    }

    private CostPlanTempDto domainToDto(CostPlanTempDomain costPlanTempDomain) {
        CostPlanTempDto dto = new CostPlanTempDto();
        BeanUtils.copyProperties(costPlanTempDomain, dto);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costPlanTempDomain.getKindNo());
        if (null != costTypeKindDomain) {
            dto.setTypeNameDto(costTypeKindDomain.getTypeName());
            dto.setKindNameDto(costTypeKindDomain.getKindName());
        }

        String filePath = costPlanTempDomain.getFilePath();
        if (null != filePath) {
            String[] split = filePath.split("&");
            if (null != split && split.length >= 1) {
                dto.setFileName(split[1]);
            }
        }

        return dto;
    }
}
