package com.blt.other.cost.service;

import com.blt.other.cost.dto.CostPlanTempApiDto;
import com.blt.other.database.model.CostPlanTempDomain;

import java.util.List;

public interface CostPlanTempService {

    String createNo();

    /**
     * <p>保存费用计划详情项</p>
     *
     * @param req 费用计划模板
     * @return resp
     */
    CostPlanTempApiDto.AddItemResp doSave(CostPlanTempApiDto.AddItemReq req);


    /**
     * <p>
     * 获取费用计划详情
     * </p>
     *
     * @param costPlanNo 费用编号
     * @return
     */
    CostPlanTempApiDto.GetCostTempByPlanNoResp getTempListByPlanNo(String costPlanNo);

    Integer deleteItemByPlanNoAndTempNo(String costPlanNo, String tempNo);

    CostPlanTempDomain getByTempNo(String tempNo);

    Integer update(CostPlanTempDomain domain);

    void deleteFilePath(String tempNo);

    List<CostPlanTempDomain> getListByPlanNoAndTypeNo(String costPlanNo, String typeNo);

    CostPlanTempDomain getByPlanNoAndTempNo(String costPlanNo, String tempNo);
}
