package com.blt.other.cost.job;

import com.blt.other.cost.service.CostCompanyService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class CostCompanySyncJob extends QuartzJobBean {

    private static Logger logger = LoggerFactory.getLogger(CostCompanySyncJob.class);

    @Autowired
    private CostCompanyService costCompanyService;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String result = costCompanyService.syncCompany();
        if (!"新增 0 条记录，更新 0 条记录".equals(result)) {
            logger.warn("Job：从财务系统获取公司主体," + result);
        }
    }
}
