package com.blt.other.cost.dto;

import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.database.model.CostPlanTempDomain;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/15 1:31 下午
 */
public final class CostPlanTempApiDto {

    @Data
    public static class AddItemResp {
        private CostPlanTempDomain tmp;
        private String msg;
        private Boolean success;
        private BigDecimal plaAmount;
    }

    @Data
    public static class AddItemReq {
        // 费用单表 id
        private Integer id;
        private String costPlanNo; // 费用计划编号
        private String tempNo; // 计划缓存编号
        private String kindNo; // 种类编号
        private String filePath; // 文件地址
        private BigDecimal amount; // 费用总金额
        private String costReason; // 付款理由
        private String dic; // 币种
        private String typeNo; // 大类编号

        private BigDecimal planAmount;
        private MultipartFile fileSelect;
    }

    @Data
    public static class GetCostTempByPlanNoResp {

        private List<CostPlanTempDto> temps;
        private BigDecimal planAmount;
        private Boolean success;
    }
}
