package com.blt.other.cost.dto;

import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.database.model.CostPlanDomain;
import com.github.pagehelper.PageInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/15 1:08 下午
 */
public final class CostPlanApiDto {

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static final class GetAllCostPlanResp {

        private Boolean success;
        private List<CostPlanDto> plans;
        private PageInfo<CostPlanDomain> pageInfo;
    }

    @Data
    public static final class GetAllCostPlanReq {

        private Integer pageNum;
        private Integer pageSize;
        private Integer userId;
        private Integer authType;
    }

    @Data
    public static final class SearchByKeyResp {
        private List<CostPlanDto> list;
    }

    @Data
    public static final class GetCostPlanResp {

        private CostPlanDomain costPlan;
        private String fileName;
    }
}
