package com.blt.other.cost.controller.costplan;

import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "付款费用计划接口")
@RestController
@RequestMapping("/cost/plan/new/pay")
public class CostPlanNewPayController {

    @Autowired
    private CostPlanService costPlanService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @ApiOperation("保存费用计划")
    @PostMapping("/save")
    public CostResult<Void> save(CostPlanDomain planDomain) {
        // 保存财务信息
        if (1 == planDomain.getCostForm() || (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend())) {
            doSaveFinansyRecord(planDomain);
        }

        costPlanService.save(planDomain);
        return CostResult.success();
    }

    @PostMapping("/reset")
    public CostResult<Void> reset(CostPlanDomain planDomain) {
        // 保存财务信息
        if (1 == planDomain.getCostForm() || (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend())) {
            doSaveFinansyRecord(planDomain);
        }

        costPlanService.update(planDomain);
        return CostResult.success();
    }

    /**
     * 保存填写的财务信息
     *
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        return userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
    }

}
