package com.blt.other.cost.controller.costplan;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.utils.CostFileUtil;
import com.blt.other.cost.utils.CostPlanUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Api(tags = "新增费用计划接口")
@RestController
@RequestMapping("/cost/plan/new")
public class CostPlanNewController {

    @Autowired
    private CostPlanService costPlanService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @ApiOperation("获取新增费用计划编号")
    @GetMapping("/getNo")
    public Map<String, Object> getNo() {

        String no = costPlanService.createNo();
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanNo", no);
        result.put("success", true);
        return result;
    }

    @ApiOperation("确认费用计划")
    @PostMapping("/affirm")
    public Map<String, Object> affirm(@RequestParam String costPlanNo) {
        Map<String, Object> result = new HashMap<>();
        try {
            Integer affirm = costPlanService.affirm(costPlanNo);
            result.put("success", true);
            result.put("msg", "已生成 " + affirm + " 张付款费用单<br>费用列表提交审核");
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            result.put("success", false);
            result.put("msg", "付款计划不存在或发生其他错误");
        }
        return result;
    }

    @PostMapping("/deleted")
    public Map<String, Object> deleted(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        try {
            costPlanService.deleted(costPlanNo);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "发生错误");
        }
        return result;
    }

    @PostMapping("/resetNoFile")
    public Map<String, Object> resetNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain planDomain = CostPlanUtils.createCostPlan(request, costPlanNo);

        try {
            // 保存财务信息
            doSaveFinansyRecord(planDomain);
            costPlanService.update(planDomain);
            Map<String, Object> result = new HashMap<>();
            result.put("success", true);
            result.put("msg", "已修改");

            return result;
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    @PostMapping("/resetFile")
    public Map<String, Object> resetFile(HttpServletResponse response, HttpServletRequest request, @RequestParam("fileSelect") MultipartFile file) {
        AxiosUtil.setCors(response, request);
        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain planDomain = CostPlanUtils.createCostPlan(request, costPlanNo);

        // 保存财务信息
//        if (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend()){
//            Integer finansyRecord = doSaveFinansyRecord(planDomain);
//        }
        Integer finansyRecord = doSaveFinansyRecord(planDomain);
        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + planDomain.getCostPlanNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        planDomain.setFilePath(path);
        costPlanService.update(planDomain);
        try {
            Map<String, Object> result = new HashMap<>();
            result.put("msg", "已修改");
            result.put("success", true);
            return result;
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }

    }

    /**
     * 保存填写的财务信息
     *
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain) {
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }
}
