package com.blt.other.cost.controller.costplan;

import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.CurUtils;
import com.blt.other.cost.dto.CostPlanApiDto;
import com.blt.other.cost.service.CostPlanSearchService;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.CostPlanTempService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan")
public class CostPlanController {

    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private CostPlanSearchService costPlanSearchService;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Autowired
    private CostPlanTempService costPlanTempService;

    @ApiOperation("查询所有费用计划")
    @GetMapping("/getAllCostPlan")
    public CostPlanApiDto.GetAllCostPlanResp getAllCostPlan(CostPlanApiDto.GetAllCostPlanReq req) {
        return costPlanService.getAllCostList(req);
    }

    @ApiOperation("搜索费用计划")
    @PostMapping("/search/key")
    public CostPlanApiDto.SearchByKeyResp searchByKey(@RequestParam String searchKey) {
        return costPlanSearchService.searchByKey(searchKey);
    }


    @ApiOperation("根据费用计划单号查询费用计划单")
    @PostMapping("getCostPlan")
    public CostPlanApiDto.GetCostPlanResp getCostPlan(@RequestParam String costPlanNo) {
        return costPlanService.getByPlanNo(costPlanNo);

    }

    @PostMapping("getPlanTmps")
    public Map<String, Object> getPlanTmps(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String costPlanNo = request.getParameter("costPlanNo");
        List<CostPlanTempDto> tempListByPlanNo = costPlanTempService.getTempListByPlanNo(costPlanNo);
        BigDecimal planAmount = new BigDecimal(0);
        if (null != tempListByPlanNo && tempListByPlanNo.size() >= 1) {
            for (CostPlanTempDto dto : tempListByPlanNo) {
                BigDecimal cny = CurUtils.getCur(dto.getDic(), "CNY", getExchangeRateApi);
                planAmount = planAmount.add(dto.getAmount().multiply(cny));
            }
        }
        Map<String, Object> result = new HashMap<>();
        result.put("tmps", tempListByPlanNo);
        result.put("planAmount", planAmount.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
        return result;
    }


    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String costPlanNo = request.getParameter("costPlanNo");

        CostPlanApiDto.GetCostPlanResp byPlanNo = costPlanService.getByPlanNo(costPlanNo);
        String filePath = byPlanNo.getCostPlan().getFilePath();
        String fileName = byPlanNo.getFileName();


        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1)));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
