package com.blt.other.commons.utils;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.purchasing.vo.CompanyVo;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.List;

public class CompanyUtil {


    public static List<CompanyVo> getCompanyList(String postCompanyListApi) {

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<>(params, headers);
        ResponseEntity<String> response = restTemplate.exchange(postCompanyListApi, HttpMethod.POST, requestEntity, String.class);

        String strBody = null;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        } else {
            return null;
        }
        assert strBody != null;
        strBody = strBody.toLowerCase();

        strBody = strBody.substring(strBody.indexOf("["), strBody.lastIndexOf("}"));
        return JsonUtilByFsJson.jsonToList(strBody, CompanyVo.class);
    }
}
