package com.blt.other.module.cost.dao;

import com.bailuntec.cost.api.dto.ManageCostDto;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.cost.dto.CheckCostListReq;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.CostExportVo;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


public interface CostDao extends BaseMapper<CostDomain> {

    /**
     * 获取费用单列表
     */
    List<CostDomain> selectAll(@Param("userId") Integer userId, @Param("projectTypeList") List<String> projectTypeList);

    /**
     * 根据 costNo 获取费用单详情
     *
     * @param costNo
     * @return
     */
    CostDomain selectByCostNo(String costNo);

    List<CostDomain> selectByKeys(CostDomain costDomain);

    List<CostDomain> selectByCostPlanNo(String costPlanNo);

    /**
     * 查询最近一次费用单
     *
     * @return 费用单
     */
    CostDomain selectLastCost();

    List<CostDomain> selectLinkLendCost(@Param("createuserid") Integer createuserid);

    /**
     * 查询管理成本费用列表，付款单+借还单
     *
     * @param startDate        startDate
     * @param endDate          endDate
     * @param feeSuperType     feeSuperType
     * @param feeSubType       feeSubType
     * @param companyValueList companyValueList
     * @param companyName      companyName
     * @param departmentName   departmentName
     * @param createUserId     createUserId
     * @param payUserId        payUserId
     * @return
     */
    List<ManageCostDto> selectManageCost(@Param("startDate") LocalDateTime startDate,
                                         @Param("endDate") LocalDateTime endDate,
                                         @Param("feeSuperType") String feeSuperType,
                                         @Param("feeSubType") String feeSubType,
                                         @Param("companyValueList") List<Integer> companyValueList,
                                         @Param("companyName") String companyName,
                                         @Param("departmentName") String departmentName,
                                         @Param("createUserId") Integer createUserId,
                                         @Param("payUserId") Integer payUserId);

    /**
     * <p>
     * 查询所有的物流费用单和采购单
     * </p>
     *
     * @param startDate        startDate
     * @param endDate          endDate
     * @param feeSuperType     feeSuperType
     * @param feeSubType       feeSubType
     * @param companyValueList companyValueList
     * @param companyName      companyName
     * @param departmentName   departmentName
     * @param createUserId     createUserId
     * @param payUserId        payUserId
     * @return
     */
    List<ManageCostDto> getLogisticsCostList(@Param("startDate") LocalDateTime startDate,
                                             @Param("endDate") LocalDateTime endDate,
                                             @Param("feeSuperType") String feeSuperType,
                                             @Param("feeSubType") String feeSubType,
                                             @Param("companyValueList") List<Integer> companyValueList,
                                             @Param("companyName") String companyName,
                                             @Param("departmentName") String departmentName,
                                             @Param("createUserId") Integer createUserId,
                                             @Param("payUserId") Integer payUserId);

    /**
     * 查询资产负债表相关费用单
     *
     * @param startDate date
     * @param endDate   date
     * @return 资产负债表相关费用单
     */
    List<CostDomain> selectBalanceSheetCost(@Param("startDate") Date startDate, @Param("endDate") Date endDate);

    List<String> listCostNoAll(CostExportVo costExportVo);

    /**
     * 审核列表查询
     *
     * @param page page
     * @return
     */
    IPage<CostDomain> checkCostList(@Param("page") IPage<CostDomain> page,
                                    @Param("req") CheckCostListReq req);
}
