package com.blt.other.module.purchasing.service;

import com.blt.other.module.database.model.BuyPlanDomain;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.vo.BuyPlanSaveVo;

import java.util.List;
import java.util.Map;

public interface BuyPlanService {

    /**
     * 获取所有的采购计划单 Dto
     * @return
     */
    Map<String,Object> getAllBuyPlanList(int pageSize, int page);

    Map<String,Object> getBuyPlanListBySearchNo(String no,Integer pageNum,Integer pageSize);

    /**
     * 根据采购计划单号获取计划单信息
     */
    BuyPlanDto getBuyPlanByNo(String no);

    Integer saveNewBuyPlan(BuyPlanSaveVo buyPlanSaveVo);

    /**
     * 更改采购计划单信息
     * @param buyPlanDomain
     * @return
     */
    Integer updateBuyPlan(BuyPlanDomain buyPlanDomain);

    /**
     * 批量审核通过
     * @param planList
     * @return
     */
    Integer batchAuditUpdate(List<String> planList,Integer audituserid,String auditusername);

    /**
     * 采购计划主管审核通过
     * @param plan
     * @return
     */
    Integer auditPass(BuyPlanDomain plan);

    /**
     * 实体转换
     * @param domains
     * @return
     */
    List<BuyPlanDto> getDtoList(List<BuyPlanDomain> domains);
}
