package com.blt.other.module.entrepot.service.impl;

import com.bailuntec.cost.api.domain.BuyDomain;
import com.blt.other.module.database.model.InventoryDomain;
import com.blt.other.module.database.model.SysProductDomain;
import com.blt.other.module.entrepot.dao.InventoryDao;
import com.blt.other.module.entrepot.service.InventoryService;
import com.blt.other.module.purchasing.dao.BuyDao;
import com.blt.other.module.purchasing.service.BuyDetailService;
import com.blt.other.module.sku.dao.SysProductDao;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class InventoryServiceImpl implements InventoryService {

    @Autowired
    private InventoryDao inventoryDao;
    @Autowired
    private SysProductDao sysProductDao;
    @Autowired
    private BuyDao buyDao;
    @Autowired
    private BuyDetailService buyDetailService;

    /**
     * 新增库存记录
     * @param buyDomain
     * @return
     */
    @Override
    public InventoryDomain saveInventory(BuyDomain buyDomain) {
        InventoryDomain inventoryDomain = new InventoryDomain();
        inventoryDomain.setInventoryNo(createInventoryNo());
        inventoryDomain.setInventoryNum(buyDomain.getCount());
        inventoryDomain.setSkucode(buyDomain.getSkucode());
        inventoryDomain.setSkuname(buyDomain.getSkuname());
        inventoryDomain.setWarehouseid(buyDomain.getWarehouseid());
        inventoryDomain.setWarehousename(buyDomain.getWarehousename());
        SysProductDomain sysProductDomain = sysProductDao.selectBySkucode(buyDomain.getSkucode());
        inventoryDomain.setSkuTypeNo(sysProductDomain.getSkuTypeNo());
        inventoryDomain.setSkuTypeName(sysProductDomain.getSkuTypeName());
        inventoryDomain.setSkuKindNo(sysProductDomain.getSkuKindNo());
        inventoryDomain.setSkuKindName(sysProductDomain.getSkuKindName());

        Integer insert = inventoryDao.insert(inventoryDomain);
        if(null != insert && insert >= 1){
            return inventoryDomain;
        }
        return null;
    }

    /**
     * 根据 sku 编号获取库存信息
     * @param skucode
     * @return
     */
    @Override
    public InventoryDomain getBySkucode(String skucode) {
        InventoryDomain inventoryDomain = inventoryDao.selectBySkucode(skucode);
        return inventoryDomain;
    }

    @Override
    public InventoryDomain getByWarehouseidAndSkucode(String warehouseid, String skucode) {
        InventoryDomain inventoryDomain = inventoryDao.selectByWarehouseidAndSkucode(warehouseid,skucode);
        return inventoryDomain;
    }

    /**
     * 更改库存
     * @param inventoryDomain
     * @param inventoryNum
     * @return
     */
    @Override
    public InventoryDomain update(InventoryDomain inventoryDomain, Integer inventoryNum) {
        inventoryDomain.setInventoryNum(inventoryNum);
        Integer update = inventoryDao.update(inventoryDomain);
        return null;
    }

    /**
     * 分页获取库存列表
     * @return
     */
    @Override
    public Map<String, Object> getAllInventories(Integer pageNum,Integer pageSize) {
        Map<String,Object> result = new HashMap<>();
        PageHelper.startPage(pageNum,pageSize);
        List<InventoryDomain> inventoryDomains = inventoryDao.selectAll();
        PageInfo<InventoryDomain> pageInfo = new PageInfo<>(inventoryDomains);

        result.put("pageInfo",pageInfo);
        result.put("inventories",inventoryDomains);
        return result;
    }

    /**
     * 获取库存信息
     * @param inventoryNo
     * @return
     */
    @Override
    public InventoryDomain getByInventoryNo(String inventoryNo) {
        InventoryDomain inventoryDomain = inventoryDao.selectByInventoryNo(inventoryNo);
        return inventoryDomain;
    }

    /**
     * 生成唯一的库存编号
     * @return
     */
    public String createInventoryNo(){
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String inventoryNo = "INV"+sdf.format(new Date())+random.nextInt(9);
        InventoryDomain inventoryDomain = inventoryDao.selectByInventoryNo(inventoryNo);
        while (null != inventoryDomain && null != inventoryDomain.getId()){
            inventoryNo = "INV"+sdf.format(new Date())+random.nextInt(9);
            inventoryDomain = inventoryDao.selectByInventoryNo(inventoryNo);
        }
        return inventoryNo;
    }
}
