package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostTypeKindDto;
import com.blt.other.module.database.model.CostTypeKindDomain;
import com.blt.other.module.database.model.LogisticsSupplierBankDomain;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

public interface CostTypeKindService {

    /**
     * 获取所有费用类型
     * @return
     */
    List<CostTypeKindDto> getAllKind();

    /**
     * 分页获取所有费用类型
     * @return
     */
    Map<String,Object> getAllKindWithPage(Integer pageNum,Integer pageSize);

    /**
     * 根据 typeNo 获取费用种类
     * @param typeNo
     * @return
     */
    List<CostTypeKindDto> getListByTypeNo(String typeNo);

    /**
     * 根据 companyNo 获取费用种类
     * @param companyNo
     * @return
     */
    List<CostTypeKindDto> getListByCompanyNo(String companyNo);

    /**
     * 保存费用种类
     * @return
     */
    Integer saveNewKind(CostTypeKindDomain costTypeKindDomain);

    /**
     * 根据 kindNo 获取费用种类详情
     * @param kindNo
     * @return
     */
    CostTypeKindDomain getKindByKindNo(String kindNo);

    /**
     * Excel 导入费用小类
     * @param file
     */
    Boolean importByExcel(MultipartFile file,String createUsercode) throws Exception;

    Integer update(CostTypeKindDomain costTypeKindDomain);

    Integer deleteKind(String kindNo);

    LogisticsSupplierBankDomain getLogisticsBank(String subSupplierName);
}
