package com.blt.other.other_supplier.service.impl;

import com.blt.other.other_database.model.BuyUserDomain;
import com.blt.other.other_supplier.dao.BuyUserDao;
import com.blt.other.other_supplier.service.BuyUserSyncService;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

/**
 * BuyUserService 实现类，用于处理采购员列表的同步
 */
@Service
public class BuyUserSyncServiceImpl implements BuyUserSyncService {
    private static Logger logger = LoggerFactory.getLogger(BuyUserSyncServiceImpl.class);

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private BuyUserDao buyUserDao;

    @Value("${url.api.buyUserApi}")
    private String buyUserApi;

    /**
     * 通过 API 接口获取用户信息列表
     * @return
     */
    @Override
    public List<BuyUserDomain> getBuyUserAllFromOA() {
//        logger.info("================ 开始获取用户列表");
        String strBody = null;
        List<BuyUserDomain> list = null;

        // ObjectMapper 用于将 JSON 格式的数据转换成 BuyUserDomain 格式；
        ObjectMapper mapper = new ObjectMapper();

        ResponseEntity<String> forEntity = restTemplate.getForEntity(buyUserApi, String.class);
        if (forEntity != null && forEntity.getStatusCodeValue() == 200){
            strBody = forEntity.getBody();
//            logger.info("API 响应成功::"+strBody);
            // 对获得的数据进行修正，转换为标准 JSON 格式
            strBody = strBody.replace("\\","");
            if (strBody.length() > 1){
                strBody = strBody.substring(1,strBody.length()-1);
            }else {
                return null;
            }
            // 使用 ObjectMapper 将 JSON 数据转为 List<BuyUserDomain> 类型
            JavaType javaType = mapper.getTypeFactory().constructParametricType(Collection.class, BuyUserDomain.class);
            try {
                strBody = strBody.toLowerCase();
                list = (List<BuyUserDomain>) mapper.readValue(strBody, javaType);
            } catch (IOException e) {
                logger.error("类型转换失败 = = = = = = = = = = = = = = = = = = = = =");
                return null;
            }
            return list;
        }
        return null;
    }

    @Override
    public int updateToBuyUser(List<BuyUserDomain> list) {
        Integer count = 0;
        Integer i = 0;
        BuyUserDomain buyUserOld = null;
        for (BuyUserDomain buyUserDomain : list){
            i = 0;
            buyUserOld = buyUserDao.selectByUserId(buyUserDomain.getUserid());
            if (buyUserOld == null){
                i = buyUserDao.insertBuyUser(buyUserDomain);
                logger.info("用户 ID ："+buyUserDomain.getUserid()+"("+buyUserDomain.getUsername()+")"+"加入其他采购系统采购员表");
            }else {
                i = buyUserDao.updateBuyUser(buyUserDomain);
                if (i != 0){
                    logger.info("采购员表 用户："+buyUserOld.getUserid()+buyUserOld.getUsername()+" 信息更改为："+buyUserDomain.getUserid()+buyUserDomain.getUsername());
                }
            }
            count = count + i;
        }
        return count;
    }
}
